/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexProgressor;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.values.storable.Value;

public class NativeHitIndexProgressor<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexProgressor<KEY, VALUE> {
    NativeHitIndexProgressor(RawCursor<Hit<KEY, VALUE>, IOException> seeker, IndexProgressor.NodeValueClient client, Collection<RawCursor<Hit<KEY, VALUE>, IOException>> toRemoveFromOnClose) {
        super(seeker, client, toRemoveFromOnClose);
    }

    @Override
    public boolean next() {
        try {
            while (this.seeker.next()) {
                NativeIndexKey key = (NativeIndexKey)((Hit)this.seeker.get()).key();
                Value[] values2 = this.extractValues(key);
                if (!this.acceptValue(values2) || !this.client.acceptNode(key.getEntityId(), values2)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected boolean acceptValue(Value[] values2) {
        return true;
    }
}

