/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

abstract class NativeIndexSingleValueKey<SELF extends NativeIndexSingleValueKey<SELF>>
extends NativeIndexKey<SELF> {
    NativeIndexSingleValueKey() {
    }

    @Override
    void assertValidValue(int stateSlot, Value value2) {
        Preconditions.requireExactlyZero(stateSlot);
        this.assertCorrectType(value2);
    }

    @Override
    void writeValue(int stateSlot, Value value2, NativeIndexKey.Inclusion inclusion) {
        value2.writeTo(this);
    }

    @Override
    final void initValueAsLowest(int stateSlot, ValueGroup valueGroup) {
        this.initValueAsLowest(valueGroup);
    }

    abstract void initValueAsLowest(ValueGroup var1);

    @Override
    final void initValueAsHighest(int stateSlot, ValueGroup valueGroup) {
        this.initValueAsHighest(valueGroup);
    }

    abstract void initValueAsHighest(ValueGroup var1);

    abstract Value assertCorrectType(Value var1);

    abstract Value asValue();

    @Override
    Value[] asValues() {
        return Iterators.array(this.asValue());
    }

    void from(Value value2) {
        this.assertCorrectType(value2);
        value2.writeTo(this);
    }

    @Override
    int numberOfStateSlots() {
        return 1;
    }
}

