/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NumberIndexKey;

abstract class NumberLayout
extends IndexLayout<NumberIndexKey, NativeIndexValue> {
    NumberLayout(long identifier2, int majorVersion, int minorVersion) {
        super(identifier2, majorVersion, minorVersion);
    }

    @Override
    public NumberIndexKey newKey() {
        return new NumberIndexKey();
    }

    @Override
    public NumberIndexKey copyKey(NumberIndexKey key, NumberIndexKey into) {
        into.type = key.type;
        into.rawValueBits = key.rawValueBits;
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        return into;
    }

    @Override
    public int keySize(NumberIndexKey key) {
        return 17;
    }

    @Override
    public void writeKey(PageCursor cursor, NumberIndexKey key) {
        cursor.putByte(key.type);
        cursor.putLong(key.rawValueBits);
        cursor.putLong(key.getEntityId());
    }

    @Override
    public void readKey(PageCursor cursor, NumberIndexKey into, int keySize) {
        into.type = cursor.getByte();
        into.rawValueBits = cursor.getLong();
        into.setEntityId(cursor.getLong());
    }

    @Override
    int compareValue(NumberIndexKey o1, NumberIndexKey o2) {
        return o1.compareValueTo(o2);
    }
}

