/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.kernel.impl.index.schema.NativeIndexSingleValueKey;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class SpatialIndexKey
extends NativeIndexSingleValueKey<SpatialIndexKey> {
    static final int SIZE = 16;
    long rawValueBits;
    CoordinateReferenceSystem crs;
    SpaceFillingCurve curve;

    SpatialIndexKey(CoordinateReferenceSystem crs, SpaceFillingCurve curve) {
        this.crs = crs;
        this.curve = curve;
    }

    @Override
    public Value asValue() {
        return Values.NO_VALUE;
    }

    @Override
    void initValueAsLowest(ValueGroup valueGroups) {
        double[] limit = new double[this.crs.getDimension()];
        Arrays.fill(limit, Double.NEGATIVE_INFINITY);
        this.writePoint(this.crs, limit);
    }

    @Override
    void initValueAsHighest(ValueGroup valueGroups) {
        double[] limit = new double[this.crs.getDimension()];
        Arrays.fill(limit, Double.NEGATIVE_INFINITY);
        limit[0] = Double.POSITIVE_INFINITY;
        this.writePoint(this.crs, limit);
    }

    void fromDerivedValue(long entityId, long derivedValue) {
        this.rawValueBits = derivedValue;
        this.initialize(entityId);
    }

    @Override
    int compareValueTo(SpatialIndexKey other2) {
        return Long.compare(this.rawValueBits, other2.rawValueBits);
    }

    @Override
    protected Value assertCorrectType(Value value2) {
        if (!Values.isGeometryValue(value2)) {
            throw new IllegalArgumentException("Key layout does only support geometries, tried to create key from " + value2);
        }
        return value2;
    }

    @Override
    public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) {
        this.rawValueBits = this.curve.derivedValueFor(coordinate);
    }

    public String toString() {
        return String.format("rawValue=%d,value=%s,entityId=%d", this.rawValueBits, "unknown", this.getEntityId());
    }
}

