/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.factory.Maps;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexKey;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class SpatialVerifyDeferredConstraint {
    SpatialVerifyDeferredConstraint() {
    }

    static void verify(NodePropertyAccessor nodePropertyAccessor, IndexLayout<SpatialIndexKey, NativeIndexValue> layout, GBPTree<SpatialIndexKey, NativeIndexValue> tree, StoreIndexDescriptor descriptor) throws IndexEntryConflictException {
        SpatialIndexKey from2 = (SpatialIndexKey)layout.newKey();
        SpatialIndexKey to2 = (SpatialIndexKey)layout.newKey();
        SpatialVerifyDeferredConstraint.initializeKeys(from2, to2);
        try (RawCursor<Hit<SpatialIndexKey, NativeIndexValue>, IOException> seek = tree.seek(from2, to2);){
            SpatialVerifyDeferredConstraint.scanAndVerifyDuplicates(nodePropertyAccessor, descriptor, seek);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void scanAndVerifyDuplicates(NodePropertyAccessor nodePropertyAccessor, StoreIndexDescriptor descriptor, RawCursor<Hit<SpatialIndexKey, NativeIndexValue>, IOException> seek) throws IOException, IndexEntryConflictException {
        Hit hit;
        LongArrayList nodesWithCollidingPoints = new LongArrayList();
        long prevRawBits = Long.MIN_VALUE;
        if (seek.next()) {
            hit = (Hit)seek.get();
            prevRawBits = ((SpatialIndexKey)hit.key()).rawValueBits;
            nodesWithCollidingPoints.add(((SpatialIndexKey)hit.key()).getEntityId());
        }
        while (seek.next()) {
            hit = (Hit)seek.get();
            SpatialIndexKey key = (SpatialIndexKey)hit.key();
            long currentRawBits = key.rawValueBits;
            long currentNodeId = key.getEntityId();
            if (prevRawBits != currentRawBits) {
                if (nodesWithCollidingPoints.size() > 1) {
                    SpatialVerifyDeferredConstraint.verifyConstraintOn(nodesWithCollidingPoints, nodePropertyAccessor, descriptor);
                }
                nodesWithCollidingPoints.clear();
            }
            nodesWithCollidingPoints.add(currentNodeId);
            prevRawBits = currentRawBits;
        }
        if (nodesWithCollidingPoints.size() > 1) {
            SpatialVerifyDeferredConstraint.verifyConstraintOn(nodesWithCollidingPoints, nodePropertyAccessor, descriptor);
        }
    }

    private static void verifyConstraintOn(LongArrayList nodeIds, NodePropertyAccessor nodePropertyAccessor, StoreIndexDescriptor descriptor) throws IndexEntryConflictException {
        MutableMap<Value, Long> points = Maps.mutable.empty();
        MutableLongIterator iter2 = nodeIds.longIterator();
        try {
            while (iter2.hasNext()) {
                long id2 = iter2.next();
                Value value2 = nodePropertyAccessor.getNodePropertyValue(id2, descriptor.schema().getPropertyId());
                Long other2 = points.getIfAbsentPut(value2, id2);
                if (other2 == id2) continue;
                throw new IndexEntryConflictException((long)other2, id2, value2);
            }
        }
        catch (EntityNotFoundException e) {
            throw new RuntimeException("Failed to validate uniqueness constraint", e);
        }
    }

    private static void initializeKeys(SpatialIndexKey from2, SpatialIndexKey to2) {
        from2.initialize(Long.MIN_VALUE);
        to2.initialize(Long.MAX_VALUE);
        from2.initValueAsLowest(ValueGroup.GEOMETRY);
        to2.initValueAsHighest(ValueGroup.GEOMETRY);
    }
}

