/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.neo4j.kernel.impl.index.schema.NativeIndexSingleValueKey;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class StringIndexKey
extends NativeIndexSingleValueKey<StringIndexKey> {
    private boolean ignoreLength;
    byte[] bytes;
    int bytesLength;
    private boolean bytesDereferenced;

    StringIndexKey() {
    }

    int size() {
        return 8 + this.bytesLength;
    }

    @Override
    protected Value assertCorrectType(Value value2) {
        if (!Values.isTextValue(value2)) {
            throw new IllegalArgumentException("Key layout does only support strings, tried to create key from " + value2);
        }
        return value2;
    }

    @Override
    void initialize(long entityId) {
        super.initialize(entityId);
        this.ignoreLength = false;
    }

    @Override
    public Value asValue() {
        if (this.bytes == null) {
            return Values.NO_VALUE;
        }
        this.bytesDereferenced = true;
        return Values.utf8Value(this.bytes, 0, this.bytesLength);
    }

    @Override
    void initValueAsLowest(ValueGroup valueGroups) {
        this.bytes = null;
    }

    @Override
    void initValueAsHighest(ValueGroup valueGroups) {
        this.bytes = null;
    }

    void initAsPrefixLow(TextValue prefix) {
        prefix.writeTo(this);
        this.initialize(Long.MIN_VALUE);
    }

    void initAsPrefixHigh(TextValue prefix) {
        prefix.writeTo(this);
        this.initialize(Long.MAX_VALUE);
        this.ignoreLength = true;
    }

    private boolean isHighest() {
        return this.getCompareId() && this.getEntityId() == Long.MAX_VALUE && this.bytes == null;
    }

    @Override
    int compareValueTo(StringIndexKey other2) {
        if (this.bytes != other2.bytes) {
            if (this.bytes == null) {
                return this.isHighest() ? 1 : -1;
            }
            if (other2.bytes == null) {
                return other2.isHighest() ? -1 : 1;
            }
        } else {
            return 0;
        }
        return StringIndexKey.lexicographicalUnsignedByteArrayCompare(this.bytes, this.bytesLength, other2.bytes, other2.bytesLength, this.ignoreLength | other2.ignoreLength);
    }

    static int lexicographicalUnsignedByteArrayCompare(byte[] a, int aLength, byte[] b, int bLength, boolean ignoreLength) {
        assert (a != null && b != null) : "Null arrays not supported.";
        if (a == b && aLength == bLength) {
            return 0;
        }
        int length2 = Math.min(aLength, bLength);
        for (int i = 0; i < length2; ++i) {
            int compare = Short.compare((short)(a[i] & 0xFF), (short)(b[i] & 0xFF));
            if (compare == 0) continue;
            return compare;
        }
        return ignoreLength ? 0 : Integer.compare(aLength, bLength);
    }

    public String toString() {
        return String.format("value=%s,entityId=%d,bytes=%s", this.asValue(), this.getEntityId(), this.bytes == null ? "null" : Arrays.toString(Arrays.copyOf(this.bytes, this.bytesLength)));
    }

    @Override
    public void writeString(String value2) {
        this.bytes = UTF8.encode(value2);
        this.bytesLength = this.bytes.length;
        this.bytesDereferenced = false;
    }

    @Override
    public void writeString(char value2) {
        this.writeString(String.valueOf(value2));
    }

    @Override
    public void writeUTF8(byte[] bytes2, int offset, int length2) {
        this.bytes = bytes2;
        this.bytesLength = length2;
        this.bytesDereferenced = true;
    }

    void copyFrom(StringIndexKey key) {
        this.copyFrom(key, key.bytesLength);
    }

    void copyFrom(StringIndexKey key, int targetLength) {
        this.setBytesLength(targetLength);
        System.arraycopy(key.bytes, 0, this.bytes, 0, targetLength);
        this.setEntityId(key.getEntityId());
        this.setCompareId(key.getCompareId());
    }

    void setBytesLength(int length2) {
        if (this.bytesDereferenced || this.bytes == null || this.bytes.length < length2) {
            this.bytesDereferenced = false;
            this.bytes = new byte[length2 + length2 / 2];
        }
        this.bytesLength = length2;
    }
}

