/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.CombiningIterable;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeIndexSingleValueKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.TemporalIndexCache;
import org.neo4j.kernel.impl.index.schema.TemporalIndexFiles;
import org.neo4j.kernel.impl.index.schema.TemporalIndexPartReader;
import org.neo4j.kernel.impl.index.schema.TemporalIndexPopulator;
import org.neo4j.kernel.impl.index.schema.TemporalIndexReader;
import org.neo4j.kernel.impl.index.schema.TemporalIndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

class TemporalIndexAccessor
extends TemporalIndexCache<PartAccessor<?>>
implements IndexAccessor {
    private final IndexDescriptor descriptor;

    TemporalIndexAccessor(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, PageCache pageCache, FileSystemAbstraction fs, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, TemporalIndexFiles temporalIndexFiles) throws IOException {
        super(new PartFactory(pageCache, fs, recoveryCleanupWorkCollector, monitor, descriptor, samplingConfig, temporalIndexFiles));
        this.descriptor = descriptor;
        temporalIndexFiles.loadExistingIndexes(this);
    }

    @Override
    public void drop() {
        FusionIndexBase.forAll(NativeIndexAccessor::drop, this);
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        return new TemporalIndexUpdater(this, mode);
    }

    @Override
    public void force(IOLimiter ioLimiter) {
        for (NativeIndexAccessor part : this) {
            part.force(ioLimiter);
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() {
        this.closeInstantiateCloseLock();
        FusionIndexBase.forAll(NativeIndexAccessor::close, this);
    }

    @Override
    public IndexReader newReader() {
        return new TemporalIndexReader(this.descriptor, this);
    }

    @Override
    public BoundedIterable<Long> newAllEntriesReader() {
        final ArrayList<BoundedIterable<Long>> allEntriesReader = new ArrayList<BoundedIterable<Long>>();
        for (NativeIndexAccessor part : this) {
            allEntriesReader.add(part.newAllEntriesReader());
        }
        return new BoundedIterable<Long>(){

            @Override
            public long maxCount() {
                long sum2 = 0L;
                for (BoundedIterable part : allEntriesReader) {
                    long partMaxCount = part.maxCount();
                    if (partMaxCount == -1L) {
                        return -1L;
                    }
                    sum2 += partMaxCount;
                }
                return sum2;
            }

            @Override
            public void close() throws Exception {
                FusionIndexBase.forAll(AutoCloseable::close, allEntriesReader);
            }

            @Override
            public Iterator<Long> iterator() {
                return new CombiningIterable(allEntriesReader).iterator();
            }
        };
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        ArrayList<ResourceIterator<File>> snapshotFiles = new ArrayList<ResourceIterator<File>>();
        for (NativeIndexAccessor part : this) {
            snapshotFiles.add(part.snapshotFiles());
        }
        return Iterators.concatResourceIterators(snapshotFiles.iterator());
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) {
    }

    @Override
    public boolean isDirty() {
        return Iterators.stream(this.iterator()).anyMatch(NativeIndexAccessor::isDirty);
    }

    static class PartFactory
    implements TemporalIndexCache.Factory<PartAccessor<?>> {
        private final PageCache pageCache;
        private final FileSystemAbstraction fs;
        private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
        private final IndexProvider.Monitor monitor;
        private final StoreIndexDescriptor descriptor;
        private final IndexSamplingConfig samplingConfig;
        private final TemporalIndexFiles temporalIndexFiles;

        PartFactory(PageCache pageCache, FileSystemAbstraction fs, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TemporalIndexFiles temporalIndexFiles) {
            this.pageCache = pageCache;
            this.fs = fs;
            this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
            this.monitor = monitor;
            this.descriptor = descriptor;
            this.samplingConfig = samplingConfig;
            this.temporalIndexFiles = temporalIndexFiles;
        }

        @Override
        public PartAccessor<?> newDate() throws IOException {
            return this.createPartAccessor(this.temporalIndexFiles.date());
        }

        @Override
        public PartAccessor<?> newLocalDateTime() throws IOException {
            return this.createPartAccessor(this.temporalIndexFiles.localDateTime());
        }

        @Override
        public PartAccessor<?> newZonedDateTime() throws IOException {
            return this.createPartAccessor(this.temporalIndexFiles.zonedDateTime());
        }

        @Override
        public PartAccessor<?> newLocalTime() throws IOException {
            return this.createPartAccessor(this.temporalIndexFiles.localTime());
        }

        @Override
        public PartAccessor<?> newZonedTime() throws IOException {
            return this.createPartAccessor(this.temporalIndexFiles.zonedTime());
        }

        @Override
        public PartAccessor<?> newDuration() throws IOException {
            return this.createPartAccessor(this.temporalIndexFiles.duration());
        }

        private <KEY extends NativeIndexSingleValueKey<KEY>> PartAccessor<KEY> createPartAccessor(TemporalIndexFiles.FileLayout<KEY> fileLayout) throws IOException {
            if (!this.fs.fileExists(fileLayout.indexFile)) {
                this.createEmptyIndex(fileLayout);
            }
            return new PartAccessor<KEY>(this.pageCache, this.fs, fileLayout, this.recoveryCleanupWorkCollector, this.monitor, this.descriptor);
        }

        private <KEY extends NativeIndexSingleValueKey<KEY>> void createEmptyIndex(TemporalIndexFiles.FileLayout<KEY> fileLayout) throws IOException {
            TemporalIndexPopulator.PartPopulator<KEY> populator = new TemporalIndexPopulator.PartPopulator<KEY>(this.pageCache, this.fs, fileLayout, this.monitor, this.descriptor);
            populator.create();
            populator.close(true);
        }
    }

    static class PartAccessor<KEY extends NativeIndexSingleValueKey<KEY>>
    extends NativeIndexAccessor<KEY, NativeIndexValue> {
        private final IndexLayout<KEY, NativeIndexValue> layout;
        private final IndexDescriptor descriptor;

        PartAccessor(PageCache pageCache, FileSystemAbstraction fs, TemporalIndexFiles.FileLayout<KEY> fileLayout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor) {
            super(pageCache, fs, fileLayout.indexFile, fileLayout.layout, monitor, descriptor, GBPTree.NO_HEADER_WRITER);
            this.layout = fileLayout.layout;
            this.descriptor = descriptor;
            this.instantiateTree(recoveryCleanupWorkCollector, this.headerWriter);
        }

        @Override
        public TemporalIndexPartReader<KEY> newReader() {
            this.assertOpen();
            return new TemporalIndexPartReader<KEY>(this.tree, this.layout, this.descriptor);
        }
    }
}

