/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.unsafe.impl.internal.dragons.NativeMemoryAllocationRefusedError;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;
import org.neo4j.util.Preconditions;

public class UnsafeDirectByteBufferFactory
implements ByteBufferFactory {
    private final MemoryAllocationTracker memoryAllocationTracker;
    private final List<Allocation> allocations = new ArrayList<Allocation>();
    private boolean closed;

    UnsafeDirectByteBufferFactory(MemoryAllocationTracker memoryAllocationTracker) {
        this.memoryAllocationTracker = memoryAllocationTracker;
    }

    @Override
    public synchronized ByteBuffer newBuffer(int bufferSize) {
        this.assertOpen();
        try {
            long address = UnsafeUtil.allocateMemory(bufferSize, this.memoryAllocationTracker);
            try {
                ByteBuffer buffer = UnsafeUtil.newDirectByteBuffer(address, bufferSize);
                UnsafeUtil.initDirectByteBuffer(buffer, address, bufferSize);
                this.allocations.add(new Allocation(address, bufferSize));
                return buffer;
            }
            catch (Exception e) {
                UnsafeUtil.free(address, bufferSize, this.memoryAllocationTracker);
                return this.allocateHeapBuffer(bufferSize);
            }
        }
        catch (NativeMemoryAllocationRefusedError allocationRefusedError) {
            return this.allocateHeapBuffer(bufferSize);
        }
    }

    private ByteBuffer allocateHeapBuffer(int bufferSize) {
        return ByteBuffer.allocate(bufferSize);
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.allocations.forEach(allocation -> UnsafeUtil.free(((Allocation)allocation).address, ((Allocation)allocation).bytes, this.memoryAllocationTracker));
            this.closed = true;
        }
    }

    private void assertOpen() {
        Preconditions.checkState(!this.closed, "Already closed");
    }

    private static class Allocation {
        private final long address;
        private final int bytes;

        Allocation(long address, int bytes2) {
            this.address = address;
            this.bytes = bytes2;
        }
    }
}

