/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.StringJoiner;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class ZonedTimeType
extends Type {
    ZonedTimeType(byte typeId) {
        super(ValueGroup.ZONED_TIME, typeId, TimeValue.MIN_VALUE, TimeValue.MAX_VALUE);
    }

    @Override
    int valueSize(GenericKey state) {
        return 12;
    }

    @Override
    void copyValue(GenericKey to2, GenericKey from2) {
        to2.long0 = from2.long0;
        to2.long1 = from2.long1;
    }

    @Override
    Value asValue(GenericKey state) {
        return ZonedTimeType.asValue(state.long0, state.long1);
    }

    @Override
    int compareValue(GenericKey left2, GenericKey right2) {
        return ZonedTimeType.compare(left2.long0, left2.long1, right2.long0, right2.long1);
    }

    @Override
    void putValue(PageCursor cursor, GenericKey state) {
        ZonedTimeType.put(cursor, state.long0, state.long1);
    }

    @Override
    boolean readValue(PageCursor cursor, int size2, GenericKey into) {
        return ZonedTimeType.read(cursor, into);
    }

    static Value asValue(long long0, long long1) {
        OffsetTime time = ZonedTimeType.asValueRaw(long0, long1);
        return time != null ? TimeValue.time(time) : Values.NO_VALUE;
    }

    static OffsetTime asValueRaw(long long0, long long1) {
        if (TimeZones.validZoneOffset((int)long1)) {
            return TimeValue.timeRaw(long0, ZoneOffset.ofTotalSeconds((int)long1));
        }
        return null;
    }

    static void put(PageCursor cursor, long long0, long long1) {
        cursor.putLong(long0);
        cursor.putInt((int)long1);
    }

    static boolean read(PageCursor cursor, GenericKey into) {
        into.writeTime(cursor.getLong(), cursor.getInt());
        return true;
    }

    static int compare(long this_long0, long this_long1, long that_long0, long that_long1) {
        int compare = Long.compare(this_long0, that_long0);
        if (compare == 0) {
            compare = Integer.compare((int)this_long1, (int)that_long1);
        }
        return compare;
    }

    void write(GenericKey state, long nanosOfDayUTC, int offsetSeconds) {
        state.long0 = nanosOfDayUTC;
        state.long1 = offsetSeconds;
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey state) {
        joiner.add("long0=" + state.long0);
        joiner.add("long1=" + state.long1);
    }
}

