/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.gis.spatial.index.curves.HilbertSpaceFillingCurve2D;
import org.neo4j.gis.spatial.index.curves.HilbertSpaceFillingCurve3D;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.config.SpatialIndexType;

public class SpaceFillingCurveSettings {
    private SpatialIndexType indexType = SpatialIndexType.SingleSpaceFillingCurve;
    int dimensions;
    int maxLevels;
    Envelope extents;

    SpaceFillingCurveSettings(int dimensions, Envelope extents, int maxLevels) {
        this.dimensions = dimensions;
        this.extents = extents;
        this.maxLevels = maxLevels;
    }

    public Consumer<PageCursor> headerWriter(byte initialIndexState) {
        return cursor -> {
            cursor.putByte(initialIndexState);
            cursor.putInt(this.indexType.id);
            this.indexType.writeHeader(this, (PageCursor)cursor);
        };
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public Envelope indexExtents() {
        return this.extents;
    }

    public SpaceFillingCurve curve() {
        if (this.dimensions == 2) {
            return new HilbertSpaceFillingCurve2D(this.extents, this.maxLevels);
        }
        if (this.dimensions == 3) {
            return new HilbertSpaceFillingCurve3D(this.extents, this.maxLevels);
        }
        throw new IllegalArgumentException("Cannot create spatial index with other than 2D or 3D coordinate reference system: " + this.dimensions + "D");
    }

    public int hashCode() {
        return 31 * this.extents.hashCode() + this.maxLevels;
    }

    public boolean equals(SpaceFillingCurveSettings other2) {
        return this.dimensions == other2.dimensions && this.maxLevels == other2.maxLevels && this.extents.equals(other2.extents);
    }

    public boolean equals(Object obj) {
        return obj instanceof SpaceFillingCurveSettings && this.equals((SpaceFillingCurveSettings)obj);
    }

    public String toString() {
        return String.format("Space filling curves settings: dimensions=%d, maxLevels=%d, min=%s, max=%s", this.dimensions, this.maxLevels, Arrays.toString(this.extents.getMin()), Arrays.toString(this.extents.getMax()));
    }

    static class SettingsFromIndexHeader
    extends SpaceFillingCurveSettings {
        private String failureMessage;

        SettingsFromIndexHeader() {
            super(0, null, 0);
        }

        void markAsFailed(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        private void markAsSucceeded() {
            this.failureMessage = null;
        }

        String getFailureMessage() {
            return this.failureMessage;
        }

        boolean isFailed() {
            return this.failureMessage != null;
        }

        Header.Reader headerReader(Function<ByteBuffer, String> onError) {
            return headerBytes -> {
                byte state = headerBytes.get();
                if (state == 0) {
                    this.failureMessage = "Unexpectedly trying to read the header of a failed index: " + (String)onError.apply(headerBytes);
                } else {
                    int typeId = headerBytes.getInt();
                    SpatialIndexType indexType = SpatialIndexType.get(typeId);
                    if (indexType == null) {
                        this.markAsFailed("Unknown spatial index type in index header: " + typeId);
                    } else {
                        this.markAsSucceeded();
                        indexType.readHeader(this, headerBytes);
                    }
                }
            };
        }
    }

    static class SettingsFromConfig
    extends SpaceFillingCurveSettings {
        SettingsFromConfig(int dimensions, int maxBits, Envelope extents) {
            super(dimensions, extents, SettingsFromConfig.calcMaxLevels(dimensions, maxBits));
        }

        private static int calcMaxLevels(int dimensions, int maxBits) {
            int maxConfigured = maxBits / dimensions;
            int maxSupported = dimensions == 2 ? 30 : 20;
            return Math.min(maxConfigured, maxSupported);
        }
    }
}

