/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.neo4j.gis.spatial.index.curves.PartialOverlapConfiguration;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.config.EnvelopeSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpatialIndexSettings;

public final class SpaceFillingCurveSettingsFactory {
    private SpaceFillingCurveSettingsFactory() {
    }

    static SpaceFillingCurveSettings fromConfig(int maxBits, EnvelopeSettings envelopeSettings) {
        return new SpaceFillingCurveSettings.SettingsFromConfig(envelopeSettings.getCrs().getDimension(), maxBits, envelopeSettings.asEnvelope());
    }

    public static SpaceFillingCurveSettings fromGBPTree(File indexFile, PageCache pageCache, Function<ByteBuffer, String> onError) throws IOException {
        SpaceFillingCurveSettings.SettingsFromIndexHeader settings = new SpaceFillingCurveSettings.SettingsFromIndexHeader();
        GBPTree.readHeader(pageCache, indexFile, settings.headerReader(onError));
        if (settings.isFailed()) {
            throw new IOException(settings.getFailureMessage());
        }
        return settings;
    }

    public static SpaceFillingCurveConfiguration getConfiguredSpaceFillingCurveConfiguration(Config config) {
        int extraLevels = config.get(SpatialIndexSettings.space_filling_curve_extra_levels);
        double topThreshold = config.get(SpatialIndexSettings.space_filling_curve_top_threshold);
        double bottomThreshold = config.get(SpatialIndexSettings.space_filling_curve_bottom_threshold);
        if (topThreshold == 0.0 || bottomThreshold == 0.0) {
            return new StandardConfiguration(extraLevels);
        }
        return new PartialOverlapConfiguration(extraLevels, topThreshold, bottomThreshold);
    }
}

