/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.nio.ByteBuffer;
import java.util.Map;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class SpaceFillingCurveSettingsReader
implements Header.Reader {
    private final Map<CoordinateReferenceSystem, SpaceFillingCurveSettings> settings;

    public SpaceFillingCurveSettingsReader(Map<CoordinateReferenceSystem, SpaceFillingCurveSettings> settings) {
        this.settings = settings;
    }

    @Override
    public void read(ByteBuffer headerBytes) {
        byte version = headerBytes.get();
        if (version != 0) {
            throw new UnsupportedOperationException("Invalid crs settings header version " + version + ", was expecting " + 0);
        }
        int count2 = headerBytes.getInt();
        for (int i = 0; i < count2; ++i) {
            this.readNext(headerBytes);
        }
    }

    private void readNext(ByteBuffer headerBytes) {
        int tableId = headerBytes.get() & 0xFF;
        int code = headerBytes.getInt();
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.get(tableId, code);
        int maxLevels = headerBytes.getShort() & 0xFFFF;
        int dimensions = headerBytes.getShort() & 0xFFFF;
        double[] min2 = new double[dimensions];
        double[] max2 = new double[dimensions];
        for (int i = 0; i < dimensions; ++i) {
            min2[i] = Double.longBitsToDouble(headerBytes.getLong());
            max2[i] = Double.longBitsToDouble(headerBytes.getLong());
        }
        Envelope extents = new Envelope(min2, max2);
        this.settings.put(crs, new SpaceFillingCurveSettings(dimensions, extents, maxLevels));
    }
}

