/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregator;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorPredicates;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.ExplicitIndex;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.txstate.TransactionCountingStateVisitor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.security.OverriddenAccessMode;
import org.neo4j.kernel.impl.api.security.RestrictedAccessMode;
import org.neo4j.kernel.impl.index.ExplicitIndexStore;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.storageengine.api.txstate.DiffSets;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.Value;

public class AllStoreHolder
extends Read {
    private final StorageReader storageReader;
    private final ExplicitIndexStore explicitIndexStore;
    private final Procedures procedures;
    private final SchemaState schemaState;
    private final Dependencies dataSourceDependencies;

    public AllStoreHolder(StorageReader storageReader, KernelTransactionImplementation ktx, DefaultCursors cursors, ExplicitIndexStore explicitIndexStore, Procedures procedures, SchemaState schemaState, Dependencies dataSourceDependencies) {
        super(cursors, ktx);
        this.storageReader = storageReader;
        this.explicitIndexStore = explicitIndexStore;
        this.procedures = procedures;
        this.schemaState = schemaState;
        this.dataSourceDependencies = dataSourceDependencies;
    }

    @Override
    public boolean nodeExists(long reference) {
        this.ktx.assertOpen();
        if (this.hasTxStateWithChanges()) {
            TransactionState txState = this.txState();
            if (txState.nodeIsDeletedInThisTx(reference)) {
                return false;
            }
            if (txState.nodeIsAddedInThisTx(reference)) {
                return true;
            }
        }
        return this.storageReader.nodeExists(reference);
    }

    @Override
    public boolean nodeDeletedInTransaction(long node) {
        this.ktx.assertOpen();
        return this.hasTxStateWithChanges() && this.txState().nodeIsDeletedInThisTx(node);
    }

    @Override
    public boolean relationshipDeletedInTransaction(long relationship) {
        this.ktx.assertOpen();
        return this.hasTxStateWithChanges() && this.txState().relationshipIsDeletedInThisTx(relationship);
    }

    @Override
    public Value nodePropertyChangeInTransactionOrNull(long node, int propertyKeyId) {
        this.ktx.assertOpen();
        return this.hasTxStateWithChanges() ? this.txState().getNodeState(node).propertyValue(propertyKeyId) : null;
    }

    @Override
    public long countsForNode(int labelId) {
        long count2 = this.countsForNodeWithoutTxState(labelId);
        if (this.ktx.hasTxStateWithChanges()) {
            CountsRecordState counts = new CountsRecordState();
            try {
                TransactionState txState = this.ktx.txState();
                txState.accept(new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, this.storageReader, txState, counts));
                if (counts.hasChanges()) {
                    count2 += counts.nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond();
                }
            }
            catch (ConstraintValidationException | CreateConstraintFailureException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count2;
    }

    @Override
    public long countsForNodeWithoutTxState(int labelId) {
        return this.storageReader.countsForNode(labelId);
    }

    @Override
    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        long count2 = this.countsForRelationshipWithoutTxState(startLabelId, typeId, endLabelId);
        if (this.ktx.hasTxStateWithChanges()) {
            CountsRecordState counts = new CountsRecordState();
            try {
                TransactionState txState = this.ktx.txState();
                txState.accept(new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, this.storageReader, txState, counts));
                if (counts.hasChanges()) {
                    count2 += counts.relationshipCount(startLabelId, typeId, endLabelId, Registers.newDoubleLongRegister()).readSecond();
                }
            }
            catch (ConstraintValidationException | CreateConstraintFailureException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count2;
    }

    @Override
    public long countsForRelationshipWithoutTxState(int startLabelId, int typeId, int endLabelId) {
        return this.storageReader.countsForRelationship(startLabelId, typeId, endLabelId);
    }

    @Override
    public boolean relationshipExists(long reference) {
        this.ktx.assertOpen();
        if (this.hasTxStateWithChanges()) {
            TransactionState txState = this.txState();
            if (txState.relationshipIsDeletedInThisTx(reference)) {
                return false;
            }
            if (txState.relationshipIsAddedInThisTx(reference)) {
                return true;
            }
        }
        return this.storageReader.relationshipExists(reference);
    }

    @Override
    long graphPropertiesReference() {
        return this.storageReader.getGraphPropertyReference();
    }

    @Override
    public IndexReader indexReader(IndexReference index, boolean fresh) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return fresh ? this.storageReader.getFreshIndexReader((IndexDescriptor)index) : this.storageReader.getIndexReader((IndexDescriptor)index);
    }

    @Override
    LabelScanReader labelScanReader() {
        return this.storageReader.getLabelScanReader();
    }

    @Override
    ExplicitIndex explicitNodeIndex(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return this.explicitIndexTxState().nodeChanges(indexName);
    }

    @Override
    ExplicitIndex explicitRelationshipIndex(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return this.explicitIndexTxState().relationshipChanges(indexName);
    }

    @Override
    public String[] nodeExplicitIndexesGetAll() {
        this.ktx.assertOpen();
        return this.explicitIndexStore.getAllNodeIndexNames();
    }

    @Override
    public boolean nodeExplicitIndexExists(String indexName, Map<String, String> customConfiguration) {
        this.ktx.assertOpen();
        return this.explicitIndexTxState().checkIndexExistence(IndexEntityType.Node, indexName, customConfiguration);
    }

    @Override
    public Map<String, String> nodeExplicitIndexGetConfiguration(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return this.explicitIndexStore.getNodeIndexConfiguration(indexName);
    }

    @Override
    public String[] relationshipExplicitIndexesGetAll() {
        this.ktx.assertOpen();
        return this.explicitIndexStore.getAllRelationshipIndexNames();
    }

    @Override
    public boolean relationshipExplicitIndexExists(String indexName, Map<String, String> customConfiguration) {
        this.ktx.assertOpen();
        return this.explicitIndexTxState().checkIndexExistence(IndexEntityType.Relationship, indexName, customConfiguration);
    }

    @Override
    public Map<String, String> relationshipExplicitIndexGetConfiguration(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return this.explicitIndexStore.getRelationshipIndexConfiguration(indexName);
    }

    @Override
    public IndexReference index(int label, int ... properties) {
        LabelSchemaDescriptor descriptor;
        this.ktx.assertOpen();
        try {
            descriptor = SchemaDescriptorFactory.forLabel(label, properties);
        }
        catch (IllegalArgumentException ignore) {
            return IndexReference.NO_INDEX;
        }
        CapableIndexDescriptor indexDescriptor = this.storageReader.indexGetForSchema(descriptor);
        if (this.ktx.hasTxStateWithChanges()) {
            DiffSets<IndexDescriptor> diffSets = this.ktx.txState().indexDiffSetsByLabel(label);
            if (indexDescriptor != null) {
                if (diffSets.isRemoved(indexDescriptor)) {
                    return IndexReference.NO_INDEX;
                }
                return indexDescriptor;
            }
            Iterator<IndexDescriptor> fromTxState = Iterators.filter(SchemaDescriptor.equalTo(descriptor), diffSets.getAdded().iterator());
            if (fromTxState.hasNext()) {
                return fromTxState.next();
            }
            return IndexReference.NO_INDEX;
        }
        return indexDescriptor != null ? indexDescriptor : IndexReference.NO_INDEX;
    }

    @Override
    public IndexReference index(SchemaDescriptor schema) {
        this.ktx.assertOpen();
        CapableIndexDescriptor indexDescriptor = this.storageReader.indexGetForSchema(schema);
        if (this.ktx.hasTxStateWithChanges()) {
            DiffSets<IndexDescriptor> diffSets = this.ktx.txState().indexDiffSetsBySchema(schema);
            if (indexDescriptor != null) {
                if (diffSets.isRemoved(indexDescriptor)) {
                    return IndexReference.NO_INDEX;
                }
                return indexDescriptor;
            }
            Iterator<IndexDescriptor> fromTxState = Iterators.filter(SchemaDescriptor.equalTo(schema), diffSets.getAdded().iterator());
            if (fromTxState.hasNext()) {
                return fromTxState.next();
            }
            return IndexReference.NO_INDEX;
        }
        return indexDescriptor != null ? indexDescriptor : IndexReference.NO_INDEX;
    }

    @Override
    public IndexReference indexReferenceUnchecked(int label, int ... properties) {
        return IndexDescriptorFactory.forSchema(SchemaDescriptorFactory.forLabel(label, properties), Optional.empty(), IndexProviderDescriptor.UNDECIDED);
    }

    @Override
    public IndexReference indexReferenceUnchecked(SchemaDescriptor schema) {
        return IndexDescriptorFactory.forSchema(schema, Optional.empty(), IndexProviderDescriptor.UNDECIDED);
    }

    @Override
    public Iterator<IndexReference> indexesGetForLabel(int labelId) {
        this.acquireSharedLock(ResourceTypes.LABEL, labelId);
        this.ktx.assertOpen();
        Iterator<IndexReference> iterator2 = this.storageReader.indexesGetForLabel(labelId);
        if (this.ktx.hasTxStateWithChanges()) {
            iterator2 = this.ktx.txState().indexDiffSetsByLabel(labelId).apply(iterator2);
        }
        return iterator2;
    }

    @Override
    public IndexReference indexGetForName(String name) {
        this.ktx.assertOpen();
        IndexDescriptor index = this.storageReader.indexGetForName(name);
        if (this.ktx.hasTxStateWithChanges()) {
            Predicate<IndexDescriptor> namePredicate = indexDescriptor -> {
                try {
                    return indexDescriptor.getUserSuppliedName().get().equals(name);
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            };
            Iterator<CapableIndexDescriptor> indexes = this.ktx.txState().indexChanges().filterAdded(namePredicate).apply(Iterators.iterator(index));
            index = Iterators.singleOrNull(indexes);
        }
        if (index == null) {
            return IndexReference.NO_INDEX;
        }
        this.acquireSharedSchemaLock(index.schema());
        return index;
    }

    @Override
    public Iterator<IndexReference> indexesGetAll() {
        this.ktx.assertOpen();
        Iterator<CapableIndexDescriptor> iterator2 = this.storageReader.indexesGetAll();
        if (this.ktx.hasTxStateWithChanges()) {
            iterator2 = this.ktx.txState().indexChanges().apply(this.storageReader.indexesGetAll());
        }
        return Iterators.map(indexDescriptor -> {
            this.acquireSharedSchemaLock(indexDescriptor.schema());
            return indexDescriptor;
        }, iterator2);
    }

    @Override
    public InternalIndexState indexGetState(IndexReference index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.acquireSharedSchemaLock(index.schema());
        this.ktx.assertOpen();
        return this.indexGetState((IndexDescriptor)index);
    }

    @Override
    public PopulationProgress indexGetPopulationProgress(IndexReference index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.acquireSharedSchemaLock(index.schema());
        this.ktx.assertOpen();
        if (this.ktx.hasTxStateWithChanges() && this.checkIndexState((IndexDescriptor)index, this.ktx.txState().indexDiffSetsBySchema(index.schema()))) {
            return PopulationProgress.NONE;
        }
        return this.storageReader.indexGetPopulationProgress(index.schema());
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(IndexReference index) {
        this.acquireSharedSchemaLock(index.schema());
        this.ktx.assertOpen();
        if (index instanceof StoreIndexDescriptor) {
            return ((StoreIndexDescriptor)index).getOwningConstraint();
        }
        return null;
    }

    @Override
    public long indexGetCommittedId(IndexReference index) throws SchemaRuleNotFoundException {
        this.acquireSharedSchemaLock(index.schema());
        this.ktx.assertOpen();
        if (index instanceof StoreIndexDescriptor) {
            return ((StoreIndexDescriptor)index).getId();
        }
        throw new SchemaRuleNotFoundException(SchemaRule.Kind.INDEX_RULE, index.schema());
    }

    @Override
    public String indexGetFailure(IndexReference index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return this.storageReader.indexGetFailure(index.schema());
    }

    @Override
    public double indexUniqueValuesSelectivity(IndexReference index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        SchemaDescriptor schema = index.schema();
        this.acquireSharedSchemaLock(schema);
        this.ktx.assertOpen();
        return this.storageReader.indexUniqueValuesPercentage(schema);
    }

    @Override
    public long indexSize(IndexReference index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        SchemaDescriptor schema = index.schema();
        this.acquireSharedSchemaLock(schema);
        this.ktx.assertOpen();
        return this.storageReader.indexSize(schema);
    }

    @Override
    public long nodesCountIndexed(IndexReference index, long nodeId, int propertyKeyId, Value value2) throws KernelException {
        this.ktx.assertOpen();
        AllStoreHolder.assertValidIndex(index);
        IndexReader reader = this.storageReader.getIndexReader((IndexDescriptor)index);
        return reader.countIndexedNodes(nodeId, new int[]{propertyKeyId}, value2);
    }

    @Override
    public long nodesGetCount() {
        this.ktx.assertOpen();
        long base = this.storageReader.nodesGetCount();
        return this.ktx.hasTxStateWithChanges() ? base + (long)this.ktx.txState().addedAndRemovedNodes().delta() : base;
    }

    @Override
    public long relationshipsGetCount() {
        this.ktx.assertOpen();
        long base = this.storageReader.relationshipsGetCount();
        return this.ktx.hasTxStateWithChanges() ? base + (long)this.ktx.txState().addedAndRemovedRelationships().delta() : base;
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(IndexReference index, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        this.ktx.assertOpen();
        AllStoreHolder.assertValidIndex(index);
        return this.storageReader.indexUpdatesAndSize(index.schema(), target);
    }

    @Override
    public Register.DoubleLongRegister indexSample(IndexReference index, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        this.ktx.assertOpen();
        AllStoreHolder.assertValidIndex(index);
        return this.storageReader.indexSample(index.schema(), target);
    }

    IndexReference indexGetCapability(IndexDescriptor schemaIndexDescriptor) {
        try {
            return this.storageReader.indexReference(schemaIndexDescriptor);
        }
        catch (IndexNotFoundKernelException e) {
            throw new IllegalStateException("Could not find capability for index " + schemaIndexDescriptor, e);
        }
    }

    InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        if (this.ktx.hasTxStateWithChanges() && this.checkIndexState(descriptor, this.ktx.txState().indexDiffSetsBySchema(descriptor.schema()))) {
            return InternalIndexState.POPULATING;
        }
        return this.storageReader.indexGetState(descriptor);
    }

    Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) {
        return this.storageReader.indexGetOwningUniquenessConstraintId(index);
    }

    IndexDescriptor indexGetForSchema(SchemaDescriptor descriptor) {
        CapableIndexDescriptor indexDescriptor = this.storageReader.indexGetForSchema(descriptor);
        Iterator<CapableIndexDescriptor> indexes = Iterators.iterator(indexDescriptor);
        if (this.ktx.hasTxStateWithChanges()) {
            indexes = Iterators.filter(SchemaDescriptor.equalTo(descriptor), this.ktx.txState().indexDiffSetsBySchema(descriptor).apply(indexes));
        }
        return Iterators.singleOrNull(indexes);
    }

    private boolean checkIndexState(IndexDescriptor index, DiffSets<IndexDescriptor> diffSet) throws IndexNotFoundKernelException {
        if (diffSet.isAdded(index)) {
            return true;
        }
        if (diffSet.isRemoved(index)) {
            throw new IndexNotFoundKernelException(String.format("Index on %s has been dropped in this transaction.", index.userDescription(SchemaUtil.idTokenNameLookup)));
        }
        return false;
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor descriptor) {
        this.acquireSharedSchemaLock(descriptor);
        this.ktx.assertOpen();
        Iterator<ConstraintDescriptor> constraints = this.storageReader.constraintsGetForSchema(descriptor);
        if (this.ktx.hasTxStateWithChanges()) {
            return this.ktx.txState().constraintsChangesForSchema(descriptor).apply(constraints);
        }
        return constraints;
    }

    @Override
    public boolean constraintExists(ConstraintDescriptor descriptor) {
        SchemaDescriptor schema = descriptor.schema();
        this.acquireSharedSchemaLock(schema);
        this.ktx.assertOpen();
        boolean inStore = this.storageReader.constraintExists(descriptor);
        if (this.ktx.hasTxStateWithChanges()) {
            DiffSets<ConstraintDescriptor> diffSet = this.ktx.txState().constraintsChangesForSchema(descriptor.schema());
            return diffSet.isAdded(descriptor) || inStore && !diffSet.isRemoved(descriptor);
        }
        return inStore;
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        this.acquireSharedLock(ResourceTypes.LABEL, labelId);
        this.ktx.assertOpen();
        Iterator<ConstraintDescriptor> constraints = this.storageReader.constraintsGetForLabel(labelId);
        if (this.ktx.hasTxStateWithChanges()) {
            return this.ktx.txState().constraintsChangesForLabel(labelId).apply(constraints);
        }
        return constraints;
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        this.ktx.assertOpen();
        Iterator<ConstraintDescriptor> constraints = this.storageReader.constraintsGetAll();
        if (this.ktx.hasTxStateWithChanges()) {
            constraints = this.ktx.txState().constraintsChanges().apply(constraints);
        }
        return Iterators.map(this::lockConstraint, constraints);
    }

    Iterator<ConstraintDescriptor> constraintsGetForProperty(int propertyKey) {
        this.ktx.assertOpen();
        Iterator<ConstraintDescriptor> constraints = this.storageReader.constraintsGetAll();
        if (this.ktx.hasTxStateWithChanges()) {
            constraints = this.ktx.txState().constraintsChanges().apply(constraints);
        }
        return Iterators.map(this::lockConstraint, Iterators.filter(SchemaDescriptorPredicates.hasProperty(propertyKey), constraints));
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        this.acquireSharedLock(ResourceTypes.RELATIONSHIP_TYPE, typeId);
        this.ktx.assertOpen();
        Iterator<ConstraintDescriptor> constraints = this.storageReader.constraintsGetForRelationshipType(typeId);
        if (this.ktx.hasTxStateWithChanges()) {
            return this.ktx.txState().constraintsChangesForRelationshipType(typeId).apply(constraints);
        }
        return constraints;
    }

    boolean nodeExistsInStore(long id2) {
        return this.storageReader.nodeExists(id2);
    }

    void getOrCreateNodeIndexConfig(String indexName, Map<String, String> customConfig) {
        this.explicitIndexStore.getOrCreateNodeIndexConfig(indexName, customConfig);
    }

    void getOrCreateRelationshipIndexConfig(String indexName, Map<String, String> customConfig) {
        this.explicitIndexStore.getOrCreateRelationshipIndexConfig(indexName, customConfig);
    }

    String indexGetFailure(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.storageReader.indexGetFailure(descriptor.schema());
    }

    @Override
    public UserFunctionHandle functionGet(QualifiedName name) {
        this.ktx.assertOpen();
        return this.procedures.function(name);
    }

    @Override
    public ProcedureHandle procedureGet(QualifiedName name) throws ProcedureException {
        this.ktx.assertOpen();
        return this.procedures.procedure(name);
    }

    @Override
    public Set<ProcedureSignature> proceduresGetAll() {
        this.ktx.assertOpen();
        return this.procedures.getAllProcedures();
    }

    @Override
    public UserFunctionHandle aggregationFunctionGet(QualifiedName name) {
        this.ktx.assertOpen();
        return this.procedures.aggregationFunction(name);
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallRead(int id2, Object[] arguments2) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsReads()) {
            throw accessMode.onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(id2, arguments2, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.READ));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallReadOverride(int id2, Object[] arguments2) throws ProcedureException {
        return this.callProcedure(id2, arguments2, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.READ));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallWrite(int id2, Object[] arguments2) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsWrites()) {
            throw accessMode.onViolation(String.format("Write operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(id2, arguments2, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.TOKEN_WRITE));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallWriteOverride(int id2, Object[] arguments2) throws ProcedureException {
        return this.callProcedure(id2, arguments2, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.TOKEN_WRITE));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallSchema(int id2, Object[] arguments2) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsSchemaWrites()) {
            throw accessMode.onViolation(String.format("Schema operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(id2, arguments2, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.FULL));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallSchemaOverride(int id2, Object[] arguments2) throws ProcedureException {
        return this.callProcedure(id2, arguments2, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.FULL));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallRead(QualifiedName name, Object[] arguments2) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsReads()) {
            throw accessMode.onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(name, arguments2, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.READ));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallReadOverride(QualifiedName name, Object[] arguments2) throws ProcedureException {
        return this.callProcedure(name, arguments2, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.READ));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallWrite(QualifiedName name, Object[] arguments2) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsWrites()) {
            throw accessMode.onViolation(String.format("Write operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(name, arguments2, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.TOKEN_WRITE));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallWriteOverride(QualifiedName name, Object[] arguments2) throws ProcedureException {
        return this.callProcedure(name, arguments2, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.TOKEN_WRITE));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallSchema(QualifiedName name, Object[] arguments2) throws ProcedureException {
        AccessMode accessMode = this.ktx.securityContext().mode();
        if (!accessMode.allowsSchemaWrites()) {
            throw accessMode.onViolation(String.format("Schema operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callProcedure(name, arguments2, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.FULL));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallSchemaOverride(QualifiedName name, Object[] arguments2) throws ProcedureException {
        return this.callProcedure(name, arguments2, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.FULL));
    }

    @Override
    public AnyValue functionCall(int id2, AnyValue[] arguments2) throws ProcedureException {
        if (!this.ktx.securityContext().mode().allowsReads()) {
            throw this.ktx.securityContext().mode().onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callFunction(id2, arguments2, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.READ));
    }

    @Override
    public AnyValue functionCall(QualifiedName name, AnyValue[] arguments2) throws ProcedureException {
        if (!this.ktx.securityContext().mode().allowsReads()) {
            throw this.ktx.securityContext().mode().onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.callFunction(name, arguments2, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.READ));
    }

    @Override
    public AnyValue functionCallOverride(int id2, AnyValue[] arguments2) throws ProcedureException {
        return this.callFunction(id2, arguments2, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.READ));
    }

    @Override
    public AnyValue functionCallOverride(QualifiedName name, AnyValue[] arguments2) throws ProcedureException {
        return this.callFunction(name, arguments2, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.READ));
    }

    @Override
    public UserAggregator aggregationFunction(int id2) throws ProcedureException {
        if (!this.ktx.securityContext().mode().allowsReads()) {
            throw this.ktx.securityContext().mode().onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.aggregationFunction(id2, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.READ));
    }

    @Override
    public UserAggregator aggregationFunction(QualifiedName name) throws ProcedureException {
        if (!this.ktx.securityContext().mode().allowsReads()) {
            throw this.ktx.securityContext().mode().onViolation(String.format("Read operations are not allowed for %s.", this.ktx.securityContext().description()));
        }
        return this.aggregationFunction(name, (AccessMode)new RestrictedAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.READ));
    }

    @Override
    public UserAggregator aggregationFunctionOverride(int id2) throws ProcedureException {
        return this.aggregationFunction(id2, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.READ));
    }

    @Override
    public UserAggregator aggregationFunctionOverride(QualifiedName name) throws ProcedureException {
        return this.aggregationFunction(name, (AccessMode)new OverriddenAccessMode(this.ktx.securityContext().mode(), AccessMode.Static.READ));
    }

    @Override
    public ValueMapper<Object> valueMapper() {
        return this.procedures.valueMapper();
    }

    @Override
    public <K, V> V schemaStateGetOrCreate(K key, Function<K, V> creator) {
        return this.schemaState.getOrCreate(key, creator);
    }

    @Override
    public void schemaStateFlush() {
        this.schemaState.clear();
    }

    ExplicitIndexStore explicitIndexStore() {
        return this.explicitIndexStore;
    }

    private RawIterator<Object[], ProcedureException> callProcedure(int id2, Object[] input2, AccessMode override) throws ProcedureException {
        RawIterator<Object[], ProcedureException> procedureCall;
        this.ktx.assertOpen();
        SecurityContext procedureSecurityContext = this.ktx.securityContext().withMode(override);
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(procedureSecurityContext);
             KernelStatement statement2 = this.ktx.acquireStatement();){
            procedureCall = this.procedures.callProcedure((Context)this.prepareContext(procedureSecurityContext), id2, input2, (ResourceTracker)statement2);
        }
        return this.createIterator(procedureSecurityContext, procedureCall);
    }

    private RawIterator<Object[], ProcedureException> callProcedure(QualifiedName name, Object[] input2, AccessMode override) throws ProcedureException {
        RawIterator<Object[], ProcedureException> procedureCall;
        this.ktx.assertOpen();
        SecurityContext procedureSecurityContext = this.ktx.securityContext().withMode(override);
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(procedureSecurityContext);
             KernelStatement statement2 = this.ktx.acquireStatement();){
            procedureCall = this.procedures.callProcedure((Context)this.prepareContext(procedureSecurityContext), name, input2, (ResourceTracker)statement2);
        }
        return this.createIterator(procedureSecurityContext, procedureCall);
    }

    private RawIterator<Object[], ProcedureException> createIterator(final SecurityContext procedureSecurityContext, final RawIterator<Object[], ProcedureException> procedureCall) {
        return new RawIterator<Object[], ProcedureException>(){

            @Override
            public boolean hasNext() throws ProcedureException {
                try (KernelTransaction.Revertable ignore = AllStoreHolder.this.ktx.overrideWith(procedureSecurityContext);){
                    boolean bl = procedureCall.hasNext();
                    return bl;
                }
            }

            @Override
            public Object[] next() throws ProcedureException {
                try (KernelTransaction.Revertable ignore = AllStoreHolder.this.ktx.overrideWith(procedureSecurityContext);){
                    Object[] objectArray = (Object[])procedureCall.next();
                    return objectArray;
                }
            }
        };
    }

    private AnyValue callFunction(int id2, AnyValue[] input2, AccessMode mode) throws ProcedureException {
        this.ktx.assertOpen();
        SecurityContext securityContext = this.ktx.securityContext().withMode(mode);
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(securityContext);){
            AnyValue anyValue = this.procedures.callFunction((Context)this.prepareContext(securityContext), id2, input2);
            return anyValue;
        }
    }

    private AnyValue callFunction(QualifiedName name, AnyValue[] input2, AccessMode mode) throws ProcedureException {
        this.ktx.assertOpen();
        SecurityContext securityContext = this.ktx.securityContext().withMode(mode);
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(securityContext);){
            AnyValue anyValue = this.procedures.callFunction((Context)this.prepareContext(securityContext), name, input2);
            return anyValue;
        }
    }

    private UserAggregator aggregationFunction(int id2, AccessMode mode) throws ProcedureException {
        this.ktx.assertOpen();
        SecurityContext securityContext = this.ktx.securityContext().withMode(mode);
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(securityContext);){
            UserAggregator userAggregator = this.procedures.createAggregationFunction((Context)this.prepareContext(securityContext), id2);
            return userAggregator;
        }
    }

    private UserAggregator aggregationFunction(QualifiedName name, AccessMode mode) throws ProcedureException {
        this.ktx.assertOpen();
        SecurityContext securityContext = this.ktx.securityContext().withMode(mode);
        try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(securityContext);){
            UserAggregator userAggregator = this.procedures.createAggregationFunction((Context)this.prepareContext(securityContext), name);
            return userAggregator;
        }
    }

    private BasicContext prepareContext(SecurityContext securityContext) {
        BasicContext ctx = new BasicContext();
        ctx.put(Context.KERNEL_TRANSACTION, this.ktx);
        ctx.put(Context.DATABASE_API, this.dataSourceDependencies.resolveDependency(GraphDatabaseAPI.class));
        ctx.put(Context.DEPENDENCY_RESOLVER, this.dataSourceDependencies);
        ctx.put(Context.THREAD, Thread.currentThread());
        ClockContext clocks = this.ktx.clocks();
        ctx.put(Context.SYSTEM_CLOCK, clocks.systemClock());
        ctx.put(Context.STATEMENT_CLOCK, clocks.statementClock());
        ctx.put(Context.TRANSACTION_CLOCK, clocks.transactionClock());
        ctx.put(Context.SECURITY_CONTEXT, securityContext);
        return ctx;
    }

    private static void assertValidIndex(IndexReference index) throws IndexNotFoundKernelException {
        if (index == IndexReference.NO_INDEX) {
            throw new IndexNotFoundKernelException("No index was found");
        }
    }

    private ConstraintDescriptor lockConstraint(ConstraintDescriptor constraint) {
        SchemaDescriptor schema = constraint.schema();
        this.ktx.statementLocks().pessimistic().acquireShared(this.ktx.lockTracer(), schema.keyType(), schema.keyId());
        return constraint;
    }
}

