/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.txstate.LongDiffSets;

class DefaultNodeLabelIndexCursor
extends IndexCursor<IndexProgressor>
implements NodeLabelIndexCursor,
IndexProgressor.NodeLabelClient {
    private Read read;
    private long node;
    private LabelSet labels;
    private LongIterator added;
    private LongSet removed;
    private final DefaultCursors pool;

    DefaultNodeLabelIndexCursor(DefaultCursors pool) {
        this.pool = pool;
        this.node = -1L;
    }

    @Override
    public void scan(IndexProgressor progressor, boolean providesLabels, int label) {
        super.initialize(progressor);
        if (this.read.hasTxStateWithChanges()) {
            LongDiffSets changes = this.read.txState().nodesWithLabelChanged(label);
            this.added = changes.augment(ImmutableEmptyLongIterator.INSTANCE);
            this.removed = PrimitiveLongCollections.mergeToSet(this.read.txState().addedAndRemovedNodes().getRemoved(), changes.getRemoved());
        }
    }

    @Override
    public void unionScan(IndexProgressor progressor, boolean providesLabels, int ... labels2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void intersectionScan(IndexProgressor progressor, boolean providesLabels, int ... labels2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean acceptNode(long reference, LabelSet labels2) {
        if (this.isRemoved(reference)) {
            return false;
        }
        this.node = reference;
        this.labels = labels2;
        return true;
    }

    @Override
    public boolean next() {
        if (this.added != null && this.added.hasNext()) {
            this.node = this.added.next();
            return true;
        }
        return this.innerNext();
    }

    public void setRead(Read read) {
        this.read = read;
    }

    @Override
    public void node(NodeCursor cursor) {
        this.read.singleNode(this.node, cursor);
    }

    @Override
    public long nodeReference() {
        return this.node;
    }

    @Override
    public LabelSet labels() {
        return this.labels;
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            super.close();
            this.node = -1L;
            this.labels = null;
            this.read = null;
            this.removed = null;
            this.pool.accept(this);
        }
    }

    @Override
    public boolean isClosed() {
        return super.isClosed();
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeLabelIndexCursor[closed state]";
        }
        return "NodeLabelIndexCursor[node=" + this.node + ", labels= " + this.labels + ", underlying record=" + super.toString() + "]";
    }

    private boolean isRemoved(long reference) {
        return this.removed != null && this.removed.contains(reference);
    }

    public void release() {
    }
}

