/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.StorageRelationshipCursor;

abstract class DefaultRelationshipCursor<STORECURSOR extends StorageRelationshipCursor>
implements RelationshipDataAccessor {
    private boolean hasChanges;
    private boolean checkHasChanges;
    final DefaultCursors pool;
    Read read;
    final STORECURSOR storeCursor;

    DefaultRelationshipCursor(DefaultCursors pool, STORECURSOR storeCursor) {
        this.pool = pool;
        this.storeCursor = storeCursor;
    }

    protected void init(Read read) {
        this.read = read;
        this.checkHasChanges = true;
    }

    @Override
    public long relationshipReference() {
        return this.storeCursor.entityReference();
    }

    @Override
    public int type() {
        return this.storeCursor.type();
    }

    @Override
    public void source(NodeCursor cursor) {
        this.read.singleNode(this.sourceNodeReference(), cursor);
    }

    @Override
    public void target(NodeCursor cursor) {
        this.read.singleNode(this.targetNodeReference(), cursor);
    }

    @Override
    public void properties(PropertyCursor cursor) {
        ((DefaultPropertyCursor)cursor).initRelationship(this.relationshipReference(), this.propertiesReference(), this.read, this.read);
    }

    @Override
    public long sourceNodeReference() {
        return this.storeCursor.sourceNodeReference();
    }

    @Override
    public long targetNodeReference() {
        return this.storeCursor.targetNodeReference();
    }

    @Override
    public long propertiesReference() {
        return this.storeCursor.propertiesReference();
    }

    protected abstract void collectAddedTxStateSnapshot();

    protected boolean hasChanges() {
        if (this.checkHasChanges) {
            this.hasChanges = this.read.hasTxStateWithChanges();
            if (this.hasChanges) {
                this.collectAddedTxStateSnapshot();
            }
            this.checkHasChanges = false;
        }
        return this.hasChanges;
    }
}

