/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipExplicitIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.schema.IndexProgressor;

class DefaultRelationshipExplicitIndexCursor
extends IndexCursor<IndexProgressor>
implements RelationshipExplicitIndexCursor,
IndexProgressor.ExplicitClient {
    private Read read;
    private int expectedSize;
    private long relationship;
    private float score;
    private final DefaultRelationshipScanCursor scanCursor;
    private final DefaultCursors pool;

    DefaultRelationshipExplicitIndexCursor(DefaultRelationshipScanCursor scanCursor, DefaultCursors pool) {
        this.scanCursor = scanCursor;
        this.pool = pool;
    }

    @Override
    public void initialize(IndexProgressor progressor, int expectedSize) {
        super.initialize(progressor);
        this.expectedSize = expectedSize;
    }

    @Override
    public boolean acceptEntity(long reference, float score) {
        this.relationship = reference;
        this.read.singleRelationship(reference, this.scanCursor);
        this.score = score;
        return true;
    }

    @Override
    public boolean next() {
        return this.innerNext();
    }

    public void setRead(Read read) {
        this.read = read;
    }

    @Override
    public int expectedTotalNumberOfResults() {
        return this.expectedSize;
    }

    @Override
    public float score() {
        return this.score;
    }

    @Override
    public void relationship(RelationshipScanCursor cursor) {
        this.read.singleRelationship(this.relationship, cursor);
    }

    @Override
    public void sourceNode(NodeCursor cursor) {
        this.read.singleNode(this.sourceNodeReference(), cursor);
    }

    @Override
    public void targetNode(NodeCursor cursor) {
        this.read.singleNode(this.targetNodeReference(), cursor);
    }

    @Override
    public int type() {
        return this.scanCursor.type();
    }

    @Override
    public long sourceNodeReference() {
        return this.scanCursor.sourceNodeReference();
    }

    @Override
    public long targetNodeReference() {
        return this.scanCursor.targetNodeReference();
    }

    @Override
    public long relationshipReference() {
        return this.relationship;
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            super.close();
            this.relationship = -1L;
            this.score = 0.0f;
            this.expectedSize = 0;
            this.read = null;
            this.pool.accept(this);
        }
    }

    @Override
    public boolean isClosed() {
        return super.isClosed();
    }

    public String toString() {
        if (this.isClosed()) {
            return "RelationshipExplicitIndexCursor[closed state]";
        }
        return "RelationshipExplicitIndexCursor[relationship=" + this.relationship + ", expectedSize=" + this.expectedSize + ", score=" + this.score + " ,underlying record=" + super.toString() + "]";
    }

    public void release() {
        this.scanCursor.release();
    }
}

