/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.function.ThrowingBiConsumer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;

public class NodeSchemaMatcher {
    private NodeSchemaMatcher() {
        throw new AssertionError((Object)"no instance");
    }

    static <SUPPLIER extends SchemaDescriptorSupplier, EXCEPTION extends Exception> void onMatchingSchema(Iterator<SUPPLIER> schemaSuppliers, NodeCursor node, PropertyCursor property, int specialPropertyId, ThrowingBiConsumer<SUPPLIER, MutableIntSet, EXCEPTION> callback) throws EXCEPTION {
        IntHashSet nodePropertyIds = null;
        while (schemaSuppliers.hasNext()) {
            SchemaDescriptorSupplier schemaSupplier = (SchemaDescriptorSupplier)schemaSuppliers.next();
            SchemaDescriptor schema = schemaSupplier.schema();
            if (!schema.isAffected(node.labels().all())) continue;
            if (nodePropertyIds == null) {
                nodePropertyIds = new IntHashSet();
                node.properties(property);
                while (property.next()) {
                    nodePropertyIds.add(property.propertyKey());
                }
            }
            if (!NodeSchemaMatcher.nodeHasSchemaProperties(nodePropertyIds, schema.getPropertyIds(), specialPropertyId)) continue;
            callback.accept(schemaSupplier, nodePropertyIds);
        }
    }

    private static boolean nodeHasSchemaProperties(IntSet nodeProperties, int[] indexPropertyIds, int changedPropertyId) {
        for (int indexPropertyId : indexPropertyIds) {
            if (indexPropertyId == changedPropertyId || nodeProperties.contains(indexPropertyId)) continue;
            return false;
        }
        return true;
    }
}

