/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.io.IOUtils;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class NodeValueClientFilter
implements IndexProgressor.NodeValueClient,
IndexProgressor {
    private final IndexProgressor.NodeValueClient target;
    private final NodeCursor node;
    private final PropertyCursor property;
    private final IndexQuery[] filters;
    private final Read read;
    private IndexProgressor progressor;

    NodeValueClientFilter(IndexProgressor.NodeValueClient target, NodeCursor node, PropertyCursor property, Read read, IndexQuery ... filters) {
        this.target = target;
        this.node = node;
        this.property = property;
        this.filters = filters;
        this.read = read;
    }

    @Override
    public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] query, IndexOrder indexOrder, boolean needsValues) {
        this.progressor = progressor;
        this.target.initialize(descriptor, this, query, indexOrder, needsValues);
    }

    @Override
    public boolean acceptNode(long reference, Value[] values2) {
        int storeLookups = 0;
        if (values2 == null) {
            for (IndexQuery filter2 : this.filters) {
                if (filter2 == null) continue;
                ++storeLookups;
            }
        } else {
            for (int i = 0; i < this.filters.length; ++i) {
                IndexQuery filter3 = this.filters[i];
                if (filter3 == null) continue;
                if (values2[i] == Values.NO_VALUE) {
                    ++storeLookups;
                    continue;
                }
                if (filter3.acceptsValue(values2[i])) continue;
                return false;
            }
        }
        if (storeLookups > 0 && !this.acceptByStoreFiltering(reference, storeLookups, values2)) {
            return false;
        }
        return this.target.acceptNode(reference, values2);
    }

    private boolean acceptByStoreFiltering(long reference, int storeLookups, Value[] values2) {
        this.read.singleNode(reference, this.node);
        if (!this.node.next()) {
            this.property.close();
            return false;
        }
        this.node.properties(this.property);
        while (storeLookups > 0 && this.property.next()) {
            for (int i = 0; i < this.filters.length; ++i) {
                IndexQuery filter2 = this.filters[i];
                if (filter2 == null || values2 != null && values2[i] != Values.NO_VALUE || this.property.propertyKey() != filter2.propertyKeyId()) continue;
                if (!filter2.acceptsValueAt(this.property)) {
                    return false;
                }
                --storeLookups;
            }
        }
        return storeLookups == 0;
    }

    @Override
    public boolean needsValues() {
        return true;
    }

    @Override
    public boolean next() {
        return this.progressor.next();
    }

    @Override
    public void close() {
        IOUtils.close(RuntimeException::new, (AutoCloseable[])new AutoCloseable[]{this.node, this.property, this.progressor});
    }
}

