/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.UnmodifiableMap;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.newapi.NodeWithPropertyValues;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

class TxStateIndexChanges {
    private static final AddedWithValuesAndRemoved EMPTY_ADDED_AND_REMOVED_WITH_VALUES = new AddedWithValuesAndRemoved(Collections.emptyList(), LongSets.immutable.empty());
    private static final AddedAndRemoved EMPTY_ADDED_AND_REMOVED = new AddedAndRemoved(LongLists.immutable.empty(), LongSets.immutable.empty());
    private static final ValueTuple MAX_STRING_TUPLE = ValueTuple.of(Values.MAX_STRING);

    TxStateIndexChanges() {
    }

    static AddedAndRemoved indexUpdatesForScan(ReadableTransactionState txState, IndexDescriptor descriptor, IndexOrder indexOrder) {
        return TxStateIndexChanges.indexUpdatesForScanAndFilter(txState, descriptor, null, indexOrder);
    }

    static AddedWithValuesAndRemoved indexUpdatesWithValuesForScan(ReadableTransactionState txState, IndexDescriptor descriptor, IndexOrder indexOrder) {
        return TxStateIndexChanges.indexUpdatesWithValuesScanAndFilter(txState, descriptor, null, indexOrder);
    }

    static AddedAndRemoved indexUpdatesForSuffixOrContains(ReadableTransactionState txState, IndexDescriptor descriptor, IndexQuery query, IndexOrder indexOrder) {
        if (descriptor.schema().getPropertyIds().length != 1) {
            throw new IllegalStateException("Suffix and contains queries are only supported for single property queries");
        }
        return TxStateIndexChanges.indexUpdatesForScanAndFilter(txState, descriptor, query, indexOrder);
    }

    static AddedWithValuesAndRemoved indexUpdatesWithValuesForSuffixOrContains(ReadableTransactionState txState, IndexDescriptor descriptor, IndexQuery query, IndexOrder indexOrder) {
        if (descriptor.schema().getPropertyIds().length != 1) {
            throw new IllegalStateException("Suffix and contains queries are only supported for single property queries");
        }
        return TxStateIndexChanges.indexUpdatesWithValuesScanAndFilter(txState, descriptor, query, indexOrder);
    }

    static AddedAndRemoved indexUpdatesForSeek(ReadableTransactionState txState, IndexDescriptor descriptor, ValueTuple values2) {
        UnmodifiableMap<ValueTuple, ? extends LongDiffSets> updates = txState.getIndexUpdates(descriptor.schema());
        if (updates != null) {
            LongDiffSets indexUpdatesForSeek = updates.get(values2);
            return indexUpdatesForSeek == null ? EMPTY_ADDED_AND_REMOVED : new AddedAndRemoved(LongLists.mutable.ofAll(indexUpdatesForSeek.getAdded()), indexUpdatesForSeek.getRemoved());
        }
        return EMPTY_ADDED_AND_REMOVED;
    }

    static AddedAndRemoved indexUpdatesForRangeSeek(ReadableTransactionState txState, IndexDescriptor descriptor, IndexQuery.RangePredicate<?> predicate, IndexOrder indexOrder) {
        boolean selectedIncludeUpper;
        ValueTuple selectedUpper;
        boolean selectedIncludeLower;
        ValueTuple selectedLower;
        Value lower = predicate.fromValue();
        Value upper = predicate.toValue();
        if (lower == null || upper == null) {
            throw new IllegalStateException("Use Values.NO_VALUE to encode the lack of a bound");
        }
        NavigableMap<ValueTuple, ? extends LongDiffSets> sortedUpdates = txState.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return EMPTY_ADDED_AND_REMOVED;
        }
        if (lower == Values.NO_VALUE) {
            selectedLower = ValueTuple.of(Values.minValue(predicate.valueGroup(), upper));
            selectedIncludeLower = true;
        } else {
            selectedLower = ValueTuple.of(lower);
            selectedIncludeLower = predicate.fromInclusive();
        }
        if (upper == Values.NO_VALUE) {
            selectedUpper = ValueTuple.of(Values.maxValue(predicate.valueGroup(), lower));
            selectedIncludeUpper = false;
        } else {
            selectedUpper = ValueTuple.of(upper);
            selectedIncludeUpper = predicate.toInclusive();
        }
        MutableLongList added = LongLists.mutable.empty();
        MutableLongSet removed = LongSets.mutable.empty();
        NavigableMap<ValueTuple, ? extends LongDiffSets> inRange = sortedUpdates.subMap(selectedLower, selectedIncludeLower, selectedUpper, selectedIncludeUpper);
        for (Map.Entry entry : inRange.entrySet()) {
            ValueTuple values2 = (ValueTuple)entry.getKey();
            LongDiffSets diffForSpecificValue = (LongDiffSets)entry.getValue();
            if (!predicate.isRegularOrder() && !predicate.acceptsValue(values2.getOnlyValue())) continue;
            added.addAll(diffForSpecificValue.getAdded());
            removed.addAll(diffForSpecificValue.getRemoved());
        }
        return new AddedAndRemoved(indexOrder == IndexOrder.DESCENDING ? added.asReversed() : added, removed);
    }

    static AddedWithValuesAndRemoved indexUpdatesWithValuesForRangeSeek(ReadableTransactionState txState, IndexDescriptor descriptor, IndexQuery.RangePredicate<?> predicate, IndexOrder indexOrder) {
        boolean selectedIncludeUpper;
        ValueTuple selectedUpper;
        boolean selectedIncludeLower;
        ValueTuple selectedLower;
        Value lower = predicate.fromValue();
        Value upper = predicate.toValue();
        if (lower == null || upper == null) {
            throw new IllegalStateException("Use Values.NO_VALUE to encode the lack of a bound");
        }
        NavigableMap<ValueTuple, ? extends LongDiffSets> sortedUpdates = txState.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return EMPTY_ADDED_AND_REMOVED_WITH_VALUES;
        }
        if (lower == Values.NO_VALUE) {
            selectedLower = ValueTuple.of(Values.minValue(predicate.valueGroup(), upper));
            selectedIncludeLower = true;
        } else {
            selectedLower = ValueTuple.of(lower);
            selectedIncludeLower = predicate.fromInclusive();
        }
        if (upper == Values.NO_VALUE) {
            selectedUpper = ValueTuple.of(Values.maxValue(predicate.valueGroup(), lower));
            selectedIncludeUpper = false;
        } else {
            selectedUpper = ValueTuple.of(upper);
            selectedIncludeUpper = predicate.toInclusive();
        }
        MutableList added = Lists.mutable.empty();
        MutableLongSet removed = LongSets.mutable.empty();
        NavigableMap<ValueTuple, ? extends LongDiffSets> inRange = sortedUpdates.subMap(selectedLower, selectedIncludeLower, selectedUpper, selectedIncludeUpper);
        for (Map.Entry entry : inRange.entrySet()) {
            ValueTuple values2 = (ValueTuple)entry.getKey();
            Value[] valuesArray = values2.getValues();
            LongDiffSets diffForSpecificValue = (LongDiffSets)entry.getValue();
            if (!predicate.isRegularOrder() && !predicate.acceptsValue(values2.getOnlyValue())) continue;
            diffForSpecificValue.getAdded().each(nodeId -> added.add(new NodeWithPropertyValues(nodeId, valuesArray)));
            removed.addAll(diffForSpecificValue.getRemoved());
        }
        return new AddedWithValuesAndRemoved(indexOrder == IndexOrder.DESCENDING ? added.asReversed() : added, removed);
    }

    static AddedAndRemoved indexUpdatesForRangeSeekByPrefix(ReadableTransactionState txState, IndexDescriptor descriptor, TextValue prefix, IndexOrder indexOrder) {
        Map.Entry<ValueTuple, ? extends LongDiffSets> entry;
        ValueTuple key;
        NavigableMap<ValueTuple, ? extends LongDiffSets> sortedUpdates = txState.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return EMPTY_ADDED_AND_REMOVED;
        }
        ValueTuple floor = ValueTuple.of(prefix);
        MutableLongList added = LongLists.mutable.empty();
        MutableLongSet removed = LongSets.mutable.empty();
        Iterator<Map.Entry<ValueTuple, ? extends LongDiffSets>> iterator2 = sortedUpdates.subMap(floor, MAX_STRING_TUPLE).entrySet().iterator();
        while (iterator2.hasNext() && ((TextValue)(key = (entry = iterator2.next()).getKey()).getOnlyValue()).startsWith(prefix)) {
            LongDiffSets diffSets = entry.getValue();
            added.addAll(diffSets.getAdded());
            removed.addAll(diffSets.getRemoved());
        }
        return new AddedAndRemoved(indexOrder == IndexOrder.DESCENDING ? added.asReversed() : added, removed);
    }

    static AddedWithValuesAndRemoved indexUpdatesWithValuesForRangeSeekByPrefix(ReadableTransactionState txState, IndexDescriptor descriptor, TextValue prefix, IndexOrder indexOrder) {
        Map.Entry<ValueTuple, ? extends LongDiffSets> entry;
        ValueTuple key;
        NavigableMap<ValueTuple, ? extends LongDiffSets> sortedUpdates = txState.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return EMPTY_ADDED_AND_REMOVED_WITH_VALUES;
        }
        ValueTuple floor = ValueTuple.of(prefix);
        MutableList added = Lists.mutable.empty();
        MutableLongSet removed = LongSets.mutable.empty();
        Iterator<Map.Entry<ValueTuple, ? extends LongDiffSets>> iterator2 = sortedUpdates.tailMap(floor).entrySet().iterator();
        while (iterator2.hasNext() && ((TextValue)(key = (entry = iterator2.next()).getKey()).getOnlyValue()).startsWith(prefix)) {
            LongDiffSets diffSets = entry.getValue();
            Value[] values2 = key.getValues();
            diffSets.getAdded().each(nodeId -> added.add(new NodeWithPropertyValues(nodeId, values2)));
            removed.addAll(diffSets.getRemoved());
        }
        return new AddedWithValuesAndRemoved(indexOrder == IndexOrder.DESCENDING ? added.asReversed() : added, removed);
    }

    private static AddedAndRemoved indexUpdatesForScanAndFilter(ReadableTransactionState txState, IndexDescriptor descriptor, IndexQuery filter2, IndexOrder indexOrder) {
        Map<ValueTuple, ? extends LongDiffSets> updates = TxStateIndexChanges.getUpdates(txState, descriptor, indexOrder);
        if (updates == null) {
            return EMPTY_ADDED_AND_REMOVED;
        }
        MutableLongList added = LongLists.mutable.empty();
        MutableLongSet removed = LongSets.mutable.empty();
        for (Map.Entry<ValueTuple, ? extends LongDiffSets> entry : updates.entrySet()) {
            ValueTuple key = entry.getKey();
            if (filter2 != null && !filter2.acceptsValue(key.getOnlyValue())) continue;
            LongDiffSets diffSet = entry.getValue();
            added.addAll(diffSet.getAdded());
            removed.addAll(diffSet.getRemoved());
        }
        return new AddedAndRemoved(indexOrder == IndexOrder.DESCENDING ? added.asReversed() : added, removed);
    }

    private static AddedWithValuesAndRemoved indexUpdatesWithValuesScanAndFilter(ReadableTransactionState txState, IndexDescriptor descriptor, IndexQuery filter2, IndexOrder indexOrder) {
        Map<ValueTuple, ? extends LongDiffSets> updates = TxStateIndexChanges.getUpdates(txState, descriptor, indexOrder);
        if (updates == null) {
            return EMPTY_ADDED_AND_REMOVED_WITH_VALUES;
        }
        MutableList added = Lists.mutable.empty();
        MutableLongSet removed = LongSets.mutable.empty();
        for (Map.Entry<ValueTuple, ? extends LongDiffSets> entry : updates.entrySet()) {
            ValueTuple key = entry.getKey();
            if (filter2 != null && !filter2.acceptsValue(key.getOnlyValue())) continue;
            Value[] values2 = key.getValues();
            LongDiffSets diffSet = entry.getValue();
            diffSet.getAdded().each(nodeId -> added.add(new NodeWithPropertyValues(nodeId, values2)));
            removed.addAll(diffSet.getRemoved());
        }
        return new AddedWithValuesAndRemoved(indexOrder == IndexOrder.DESCENDING ? added.asReversed() : added, removed);
    }

    private static Map<ValueTuple, ? extends LongDiffSets> getUpdates(ReadableTransactionState txState, IndexDescriptor descriptor, IndexOrder indexOrder) {
        return indexOrder == IndexOrder.NONE ? txState.getIndexUpdates(descriptor.schema()) : txState.getSortedIndexUpdates(descriptor.schema());
    }

    public static class AddedWithValuesAndRemoved {
        private final Iterable<NodeWithPropertyValues> added;
        private final LongSet removed;

        AddedWithValuesAndRemoved(Iterable<NodeWithPropertyValues> added, LongSet removed) {
            this.added = added;
            this.removed = removed;
        }

        public boolean isEmpty() {
            return !this.added.iterator().hasNext() && this.removed.isEmpty();
        }

        public Iterable<NodeWithPropertyValues> getAdded() {
            return this.added;
        }

        public LongSet getRemoved() {
            return this.removed;
        }
    }

    public static class AddedAndRemoved {
        private final LongIterable added;
        private final LongSet removed;

        AddedAndRemoved(LongIterable added, LongSet removed) {
            this.added = added;
            this.removed = removed;
        }

        public boolean isEmpty() {
            return this.added.isEmpty() && this.removed.isEmpty();
        }

        public LongIterable getAdded() {
            return this.added;
        }

        public LongSet getRemoved() {
            return this.removed;
        }
    }
}

