/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.List;
import java.util.function.Function;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.kernel.impl.proc.ParseUtil;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.Values;

public class ByteArrayConverter
implements Function<String, DefaultParameterValue>,
FieldSignature.InputMapper {
    @Override
    public DefaultParameterValue apply(String s2) {
        String value2 = s2.trim();
        if (value2.equalsIgnoreCase("null")) {
            return DefaultParameterValue.ntByteArray(null);
        }
        List values2 = ParseUtil.parseList(value2, Long.class);
        byte[] bytes2 = new byte[values2.size()];
        for (int i = 0; i < bytes2.length; ++i) {
            bytes2[i] = ((Long)values2.get(i)).byteValue();
        }
        return DefaultParameterValue.ntByteArray(bytes2);
    }

    @Override
    public Object map(Object input2) {
        if (input2 instanceof byte[]) {
            return input2;
        }
        if (input2 instanceof List) {
            List list2 = (List)input2;
            byte[] bytes2 = new byte[list2.size()];
            for (int a = 0; a < bytes2.length; ++a) {
                Object value2 = list2.get(a);
                if (!(value2 instanceof Byte)) {
                    throw new IllegalArgumentException("Cannot convert " + value2 + " to byte for input to procedure");
                }
                bytes2[a] = (Byte)value2;
            }
            return bytes2;
        }
        throw new IllegalArgumentException("Cannot convert " + input2.getClass().getSimpleName() + " to byte[] for input to procedure");
    }

    @Override
    public AnyValue map(AnyValue input2) {
        if (input2 instanceof ByteArray) {
            return input2;
        }
        if (input2 instanceof SequenceValue) {
            SequenceValue list2 = (SequenceValue)((Object)input2);
            if (list2.iterationPreference() == SequenceValue.IterationPreference.RANDOM_ACCESS) {
                byte[] bytes2 = new byte[list2.length()];
                for (int a = 0; a < bytes2.length; ++a) {
                    bytes2[a] = this.asByte(list2.value(a));
                }
                return Values.byteArray(bytes2);
            }
            byte[] bytes3 = new byte[list2.length()];
            int i = 0;
            for (AnyValue anyValue : list2) {
                bytes3[i++] = this.asByte(anyValue);
            }
            return Values.byteArray(bytes3);
        }
        throw new IllegalArgumentException("Cannot convert " + input2.getClass().getSimpleName() + " to byte[] for input to procedure");
    }

    private byte asByte(AnyValue value2) {
        if (value2 instanceof ByteValue) {
            return ((ByteValue)value2).value();
        }
        throw new IllegalArgumentException("Cannot convert " + value2.map(new DefaultValueMapper(null)) + " to byte for input to procedure");
    }
}

