/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.io.File;
import java.util.Set;
import org.neo4j.collection.RawIterator;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregator;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.CallableUserAggregationFunction;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.builtinprocs.SpecialBuiltInProcedures;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.ProcedureConfig;
import org.neo4j.kernel.impl.proc.ProcedureJarLoader;
import org.neo4j.kernel.impl.proc.ProcedureRegistry;
import org.neo4j.kernel.impl.proc.ReflectiveProcedureCompiler;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;

public class Procedures
extends LifecycleAdapter {
    private final ProcedureRegistry registry = new ProcedureRegistry();
    private final TypeMappers typeMappers;
    private final ComponentRegistry safeComponents = new ComponentRegistry();
    private final ComponentRegistry allComponents = new ComponentRegistry();
    private final ReflectiveProcedureCompiler compiler;
    private final ThrowingConsumer<Procedures, ProcedureException> builtin;
    private final File pluginDir;
    private final Log log;

    public Procedures() {
        this(null, new SpecialBuiltInProcedures("N/A", "N/A"), null, NullLog.getInstance(), ProcedureConfig.DEFAULT);
    }

    public Procedures(EmbeddedProxySPI proxySPI, ThrowingConsumer<Procedures, ProcedureException> builtin, File pluginDir, Log log, ProcedureConfig config) {
        this.builtin = builtin;
        this.pluginDir = pluginDir;
        this.log = log;
        this.typeMappers = new TypeMappers(proxySPI);
        this.compiler = new ReflectiveProcedureCompiler(this.typeMappers, this.safeComponents, this.allComponents, log, config);
    }

    public void register(CallableProcedure proc) throws ProcedureException {
        this.register(proc, false);
    }

    public void register(CallableUserFunction function) throws ProcedureException {
        this.register(function, false);
    }

    public void register(CallableUserAggregationFunction function) throws ProcedureException {
        this.register(function, false);
    }

    public void register(CallableUserFunction function, boolean overrideCurrentImplementation) throws ProcedureException {
        this.registry.register(function, overrideCurrentImplementation);
    }

    public void register(CallableUserAggregationFunction function, boolean overrideCurrentImplementation) throws ProcedureException {
        this.registry.register(function, overrideCurrentImplementation);
    }

    public void register(CallableProcedure proc, boolean overrideCurrentImplementation) throws ProcedureException {
        this.registry.register(proc, overrideCurrentImplementation);
    }

    public void registerProcedure(Class<?> proc) throws KernelException {
        this.registerProcedure(proc, false);
    }

    public void registerProcedure(Class<?> proc, boolean overrideCurrentImplementation) throws KernelException {
        this.registerProcedure(proc, overrideCurrentImplementation, null);
    }

    public void registerProcedure(Class<?> proc, boolean overrideCurrentImplementation, String warning) throws KernelException {
        for (CallableProcedure procedure : this.compiler.compileProcedure(proc, warning, true)) {
            this.register(procedure, overrideCurrentImplementation);
        }
    }

    public void registerBuiltInFunctions(Class<?> func) throws KernelException {
        for (CallableUserFunction function : this.compiler.withoutNamingRestrictions().compileFunction(func)) {
            this.register(function, false);
        }
    }

    public void registerFunction(Class<?> func) throws KernelException {
        this.registerFunction(func, false);
    }

    public void registerAggregationFunction(Class<?> func, boolean overrideCurrentImplementation) throws KernelException {
        for (CallableUserAggregationFunction function : this.compiler.compileAggregationFunction(func)) {
            this.register(function, overrideCurrentImplementation);
        }
    }

    public void registerAggregationFunction(Class<?> func) throws KernelException {
        this.registerAggregationFunction(func, false);
    }

    public void registerFunction(Class<?> func, boolean overrideCurrentImplementation) throws KernelException {
        for (CallableUserFunction function : this.compiler.compileFunction(func)) {
            this.register(function, overrideCurrentImplementation);
        }
    }

    public void registerType(Class<?> javaClass, Neo4jTypes.AnyType type) {
        this.typeMappers.registerType(javaClass, new TypeMappers.DefaultValueConverter(type, javaClass));
    }

    public <T> void registerComponent(Class<T> cls, ComponentRegistry.Provider<T> provider, boolean safe) {
        if (safe) {
            this.safeComponents.register(cls, provider);
        }
        this.allComponents.register(cls, provider);
    }

    public ProcedureHandle procedure(QualifiedName name) throws ProcedureException {
        return this.registry.procedure(name);
    }

    public UserFunctionHandle function(QualifiedName name) {
        return this.registry.function(name);
    }

    public UserFunctionHandle aggregationFunction(QualifiedName name) {
        return this.registry.aggregationFunction(name);
    }

    public Set<ProcedureSignature> getAllProcedures() {
        return this.registry.getAllProcedures();
    }

    public Set<UserFunctionSignature> getAllFunctions() {
        return this.registry.getAllFunctions();
    }

    public RawIterator<Object[], ProcedureException> callProcedure(Context ctx, QualifiedName name, Object[] input2, ResourceTracker resourceTracker) throws ProcedureException {
        return this.registry.callProcedure(ctx, name, input2, resourceTracker);
    }

    public RawIterator<Object[], ProcedureException> callProcedure(Context ctx, int id2, Object[] input2, ResourceTracker resourceTracker) throws ProcedureException {
        return this.registry.callProcedure(ctx, id2, input2, resourceTracker);
    }

    public AnyValue callFunction(Context ctx, QualifiedName name, AnyValue[] input2) throws ProcedureException {
        return this.registry.callFunction(ctx, name, input2);
    }

    public AnyValue callFunction(Context ctx, int id2, AnyValue[] input2) throws ProcedureException {
        return this.registry.callFunction(ctx, id2, input2);
    }

    public UserAggregator createAggregationFunction(Context ctx, QualifiedName name) throws ProcedureException {
        return this.registry.createAggregationFunction(ctx, name);
    }

    public UserAggregator createAggregationFunction(Context ctx, int id2) throws ProcedureException {
        return this.registry.createAggregationFunction(ctx, id2);
    }

    public ValueMapper<Object> valueMapper() {
        return this.typeMappers;
    }

    @Override
    public void start() throws Throwable {
        ProcedureJarLoader loader = new ProcedureJarLoader(this.compiler, this.log);
        ProcedureJarLoader.Callables callables = loader.loadProceduresFromDir(this.pluginDir);
        for (CallableProcedure callableProcedure : callables.procedures()) {
            this.register(callableProcedure);
        }
        for (CallableUserFunction callableUserFunction : callables.functions()) {
            this.register(callableUserFunction);
        }
        for (CallableUserAggregationFunction callableUserAggregationFunction : callables.aggregationFunctions()) {
            this.register(callableUserAggregationFunction);
        }
        this.builtin.accept(this);
    }
}

