/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.kernel.impl.proc.temporal.TemporalFunction;
import org.neo4j.procedure.Description;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Create a LocalDateTime instant.")
class LocalDateTimeFunction
extends TemporalFunction<LocalDateTimeValue> {
    LocalDateTimeFunction(Supplier<ZoneId> defaultZone) {
        super(Neo4jTypes.NTLocalDateTime, defaultZone);
    }

    @Override
    protected LocalDateTimeValue now(Clock clock, String timezone, Supplier<ZoneId> defaultZone) {
        return timezone == null ? LocalDateTimeValue.now(clock, defaultZone) : LocalDateTimeValue.now(clock, timezone);
    }

    @Override
    protected LocalDateTimeValue parse(TextValue value2, Supplier<ZoneId> defaultZone) {
        return LocalDateTimeValue.parse(value2);
    }

    @Override
    protected LocalDateTimeValue build(MapValue map2, Supplier<ZoneId> defaultZone) {
        return LocalDateTimeValue.build(map2, defaultZone);
    }

    @Override
    protected LocalDateTimeValue select(AnyValue from2, Supplier<ZoneId> defaultZone) {
        return LocalDateTimeValue.select(from2, defaultZone);
    }

    @Override
    protected LocalDateTimeValue truncate(TemporalUnit unit, TemporalValue input2, MapValue fields, Supplier<ZoneId> defaultZone) {
        return LocalDateTimeValue.truncate(unit, input2, fields, defaultZone);
    }
}

