/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.Key;
import org.neo4j.kernel.impl.proc.ProcedureConfig;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.proc.temporal.DateFunction;
import org.neo4j.kernel.impl.proc.temporal.DateTimeFunction;
import org.neo4j.kernel.impl.proc.temporal.DurationFunction;
import org.neo4j.kernel.impl.proc.temporal.LocalDateTimeFunction;
import org.neo4j.kernel.impl.proc.temporal.LocalTimeFunction;
import org.neo4j.kernel.impl.proc.temporal.TimeFunction;
import org.neo4j.procedure.Description;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public abstract class TemporalFunction<T extends AnyValue>
implements CallableUserFunction {
    private static final String DEFAULT_TEMPORAL_ARGUMENT = "DEFAULT_TEMPORAL_ARGUMENT";
    private static final TextValue DEFAULT_TEMPORAL_ARGUMENT_VALUE = Values.stringValue("DEFAULT_TEMPORAL_ARGUMENT");
    private static final DefaultParameterValue DEFAULT_PARAMETER_VALUE = new DefaultParameterValue("DEFAULT_TEMPORAL_ARGUMENT", Neo4jTypes.NTAny);
    private static final Key<Clock> DEFAULT_CLOCK = Context.STATEMENT_CLOCK;
    private static final List<FieldSignature> INPUT_SIGNATURE = Collections.singletonList(FieldSignature.inputField("input", Neo4jTypes.NTAny, DEFAULT_PARAMETER_VALUE));
    private static final String[] ALLOWED = new String[0];
    private final UserFunctionSignature signature;
    private final Supplier<ZoneId> defaultZone;

    public static void registerTemporalFunctions(Procedures procedures, ProcedureConfig procedureConfig) throws ProcedureException {
        Supplier<ZoneId> defaultZone = procedureConfig::getDefaultTemporalTimeZone;
        TemporalFunction.register(new DateTimeFunction(defaultZone), procedures);
        TemporalFunction.register(new LocalDateTimeFunction(defaultZone), procedures);
        TemporalFunction.register(new DateFunction(defaultZone), procedures);
        TemporalFunction.register(new TimeFunction(defaultZone), procedures);
        TemporalFunction.register(new LocalTimeFunction(defaultZone), procedures);
        DurationFunction.register(procedures);
    }

    protected abstract T now(Clock var1, String var2, Supplier<ZoneId> var3);

    protected abstract T parse(TextValue var1, Supplier<ZoneId> var2);

    protected abstract T build(MapValue var1, Supplier<ZoneId> var2);

    protected abstract T select(AnyValue var1, Supplier<ZoneId> var2);

    protected abstract T truncate(TemporalUnit var1, TemporalValue var2, MapValue var3, Supplier<ZoneId> var4);

    TemporalFunction(Neo4jTypes.AnyType result2, Supplier<ZoneId> defaultZone) {
        String basename = TemporalFunction.basename(this.getClass());
        assert (result2.getClass().getSimpleName().equals(basename + "Type")) : "result type should match function name";
        Description description = this.getClass().getAnnotation(Description.class);
        this.signature = new UserFunctionSignature(new QualifiedName(new String[0], basename.toLowerCase()), INPUT_SIGNATURE, result2, null, ALLOWED, description == null ? null : description.value(), true);
        this.defaultZone = defaultZone;
    }

    private static void register(TemporalFunction<?> base, Procedures procedures) throws ProcedureException {
        procedures.register(base);
        procedures.register(new Now(base, "transaction"));
        procedures.register(new Now(base, "statement"));
        procedures.register(new Now(base, "realtime"));
        procedures.register(new Truncate(base));
        base.registerMore(procedures);
    }

    private static String basename(Class<? extends TemporalFunction> function) {
        return function.getSimpleName().replace("Function", "");
    }

    void registerMore(Procedures procedures) throws ProcedureException {
    }

    @Override
    public final UserFunctionSignature signature() {
        return this.signature;
    }

    @Override
    public final AnyValue apply(Context ctx, AnyValue[] input2) throws ProcedureException {
        if (input2 == null || input2.length > 0 && (input2[0] == Values.NO_VALUE || input2[0] == null)) {
            return Values.NO_VALUE;
        }
        if (input2.length == 0 || input2[0].equals(DEFAULT_TEMPORAL_ARGUMENT_VALUE)) {
            return this.now(ctx.get(DEFAULT_CLOCK), null, this.defaultZone);
        }
        if (input2[0] instanceof TextValue) {
            return this.parse((TextValue)input2[0], this.defaultZone);
        }
        if (input2[0] instanceof TemporalValue) {
            return this.select(input2[0], this.defaultZone);
        }
        if (input2[0] instanceof MapValue) {
            MapValue map2 = (MapValue)input2[0];
            String timezone = TemporalFunction.onlyTimezone(map2);
            if (timezone != null) {
                return this.now(ctx.get(DEFAULT_CLOCK), timezone, this.defaultZone);
            }
            return this.build(map2, this.defaultZone);
        }
        throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input2), new Object[0]);
    }

    private static String onlyTimezone(MapValue map2) {
        AnyValue timezone;
        String key;
        if (map2.size() == 1 && "timezone".equalsIgnoreCase(key = Iterables.single(map2.keySet())) && (timezone = map2.get(key)) instanceof TextValue) {
            return ((TextValue)timezone).stringValue();
        }
        return null;
    }

    static /* synthetic */ DefaultParameterValue access$200() {
        return DEFAULT_PARAMETER_VALUE;
    }

    private static class Truncate<T extends AnyValue>
    extends SubFunction<T> {
        private static final List<FieldSignature> SIGNATURE = Arrays.asList(FieldSignature.inputField("unit", Neo4jTypes.NTString), FieldSignature.inputField("input", Neo4jTypes.NTAny), FieldSignature.inputField("fields", (Neo4jTypes.AnyType)Neo4jTypes.NTMap, DefaultParameterValue.nullValue(Neo4jTypes.NTMap)));

        Truncate(TemporalFunction<T> function) {
            super(function, "truncate", SIGNATURE, String.format("Truncate the input temporal value to a %s instant using the specified unit.", TemporalFunction.basename(function.getClass())));
        }

        public T apply(Context ctx, AnyValue[] args) throws ProcedureException {
            if (args != null && args.length >= 2 && args.length <= 3) {
                MapValue fields;
                AnyValue unit = args[0];
                AnyValue input2 = args[1];
                AnyValue anyValue = fields = args.length == 2 || args[2] == Values.NO_VALUE ? VirtualValues.EMPTY_MAP : args[2];
                if (unit instanceof TextValue && input2 instanceof TemporalValue && fields instanceof MapValue) {
                    return this.function.truncate(Truncate.unit(((TextValue)unit).stringValue()), (TemporalValue)input2, fields, this.function.defaultZone);
                }
            }
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(args), new Object[0]);
        }

        private static TemporalUnit unit(String unit) {
            switch (unit) {
                case "millennium": {
                    return ChronoUnit.MILLENNIA;
                }
                case "century": {
                    return ChronoUnit.CENTURIES;
                }
                case "decade": {
                    return ChronoUnit.DECADES;
                }
                case "year": {
                    return ChronoUnit.YEARS;
                }
                case "weekYear": {
                    return IsoFields.WEEK_BASED_YEARS;
                }
                case "quarter": {
                    return IsoFields.QUARTER_YEARS;
                }
                case "month": {
                    return ChronoUnit.MONTHS;
                }
                case "week": {
                    return ChronoUnit.WEEKS;
                }
                case "day": {
                    return ChronoUnit.DAYS;
                }
                case "hour": {
                    return ChronoUnit.HOURS;
                }
                case "minute": {
                    return ChronoUnit.MINUTES;
                }
                case "second": {
                    return ChronoUnit.SECONDS;
                }
                case "millisecond": {
                    return ChronoUnit.MILLIS;
                }
                case "microsecond": {
                    return ChronoUnit.MICROS;
                }
            }
            throw new IllegalArgumentException("Unsupported unit: " + unit);
        }
    }

    private static class Now<T extends AnyValue>
    extends SubFunction<T> {
        private static final List<FieldSignature> SIGNATURE = Collections.singletonList(FieldSignature.inputField("timezone", Neo4jTypes.NTAny, TemporalFunction.access$200()));
        private final Key<Clock> key;

        Now(TemporalFunction<T> function, String clock) {
            super(function, clock, SIGNATURE, String.format("Get the current %s instant using the %s clock.", TemporalFunction.basename(function.getClass()), clock));
            switch (clock) {
                case "transaction": {
                    this.key = Context.TRANSACTION_CLOCK;
                    break;
                }
                case "statement": {
                    this.key = Context.STATEMENT_CLOCK;
                    break;
                }
                case "realtime": {
                    this.key = Context.SYSTEM_CLOCK;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized clock: " + clock);
                }
            }
        }

        @Override
        public AnyValue apply(Context ctx, AnyValue[] input2) throws ProcedureException {
            if (input2 == null || input2.length > 0 && (input2[0] == Values.NO_VALUE || input2[0] == null)) {
                return Values.NO_VALUE;
            }
            if (input2.length == 0 || input2[0].equals(DEFAULT_TEMPORAL_ARGUMENT_VALUE)) {
                return this.function.now(ctx.get(this.key), null, this.function.defaultZone);
            }
            if (input2.length == 1 && input2[0] instanceof TextValue) {
                TextValue timezone = (TextValue)input2[0];
                return this.function.now(ctx.get(this.key), timezone.stringValue(), this.function.defaultZone);
            }
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input2), new Object[0]);
        }
    }

    private static abstract class SubFunction<T extends AnyValue>
    implements CallableUserFunction {
        private final UserFunctionSignature signature;
        final TemporalFunction<T> function;

        SubFunction(TemporalFunction<T> base, String name, List<FieldSignature> input2, String description) {
            this.function = base;
            this.signature = new UserFunctionSignature(new QualifiedName(new String[]{((TemporalFunction)base).signature.name().name()}, name), input2, ((TemporalFunction)base).signature.outputType(), null, ALLOWED, description, true);
        }

        @Override
        public final UserFunctionSignature signature() {
            return this.signature;
        }

        @Override
        public abstract AnyValue apply(Context var1, AnyValue[] var2) throws ProcedureException;
    }
}

