/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.Comparator;
import java.util.List;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.query.NoQueryEngine;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public abstract class QueryEngineProvider
extends Service {
    public QueryEngineProvider(String name) {
        super(name, new String[0]);
    }

    protected abstract QueryExecutionEngine createEngine(Dependencies var1, GraphDatabaseAPI var2);

    protected abstract int enginePriority();

    public static QueryExecutionEngine initialize(Dependencies deps2, GraphDatabaseAPI graphAPI, Iterable<QueryEngineProvider> providers) {
        List<QueryEngineProvider> engineProviders = Iterables.asList(providers);
        engineProviders.sort(Comparator.comparingInt(QueryEngineProvider::enginePriority));
        QueryEngineProvider provider = Iterables.firstOrNull(engineProviders);
        if (provider == null) {
            return QueryEngineProvider.noEngine();
        }
        QueryExecutionEngine engine = provider.createEngine(deps2, graphAPI);
        return deps2.satisfyDependency(engine);
    }

    public static QueryExecutionEngine noEngine() {
        return NoQueryEngine.INSTANCE;
    }
}

