/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.impl.scheduler.GroupedDaemonThreadFactory;
import org.neo4j.kernel.impl.scheduler.PooledJobHandle;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;

final class ThreadPool {
    private final GroupedDaemonThreadFactory threadFactory;
    private final ExecutorService executor;
    private final ConcurrentHashMap<Object, Future<?>> registry;
    private InterruptedException shutdownInterrupted;

    ThreadPool(Group group, ThreadGroup parentThreadGroup) {
        this.threadFactory = new GroupedDaemonThreadFactory(group, parentThreadGroup);
        this.executor = group.buildExecutorService(this.threadFactory);
        this.registry = new ConcurrentHashMap();
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public JobHandle submit(Runnable job) {
        Object registryKey = new Object();
        Runnable registeredJob = () -> {
            try {
                job.run();
            }
            finally {
                this.registry.remove(registryKey);
            }
        };
        Future<?> future = this.executor.submit(registeredJob);
        this.registry.put(registryKey, future);
        return new PooledJobHandle(future, registryKey, this.registry);
    }

    void cancelAllJobs() {
        this.registry.values().removeIf(future -> {
            future.cancel(true);
            return true;
        });
    }

    void shutDown() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.shutdownInterrupted = e;
        }
    }

    InterruptedException getShutdownException() {
        return this.shutdownInterrupted;
    }
}

