/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.Iterator;
import java.util.Optional;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.TransactionRecordState;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

class TransactionToRecordStateVisitor
extends TxStateVisitor.Adapter {
    private boolean clearSchemaState;
    private final TransactionRecordState recordState;
    private final SchemaState schemaState;
    private final SchemaStorage schemaStorage;
    private final ConstraintSemantics constraintSemantics;

    TransactionToRecordStateVisitor(TransactionRecordState recordState, SchemaState schemaState, SchemaStorage schemaStorage, ConstraintSemantics constraintSemantics) {
        this.recordState = recordState;
        this.schemaState = schemaState;
        this.schemaStorage = schemaStorage;
        this.constraintSemantics = constraintSemantics;
    }

    @Override
    public void close() {
        try {
            if (this.clearSchemaState) {
                this.schemaState.clear();
            }
        }
        finally {
            this.clearSchemaState = false;
        }
    }

    @Override
    public void visitCreatedNode(long id2) {
        this.recordState.nodeCreate(id2);
    }

    @Override
    public void visitDeletedNode(long id2) {
        this.recordState.nodeDelete(id2);
    }

    @Override
    public void visitCreatedRelationship(long id2, int type, long startNode, long endNode) {
        this.recordState.relCreate(id2, type, startNode, endNode);
    }

    @Override
    public void visitDeletedRelationship(long id2) {
        this.recordState.relDelete(id2);
    }

    @Override
    public void visitNodePropertyChanges(long id2, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
        StorageProperty prop;
        removed.each(propId -> this.recordState.nodeRemoveProperty(id2, propId));
        while (changed.hasNext()) {
            prop = changed.next();
            this.recordState.nodeChangeProperty(id2, prop.propertyKeyId(), prop.value());
        }
        while (added.hasNext()) {
            prop = added.next();
            this.recordState.nodeAddProperty(id2, prop.propertyKeyId(), prop.value());
        }
    }

    @Override
    public void visitRelPropertyChanges(long id2, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
        StorageProperty prop;
        removed.each(relId -> this.recordState.relRemoveProperty(id2, relId));
        while (changed.hasNext()) {
            prop = changed.next();
            this.recordState.relChangeProperty(id2, prop.propertyKeyId(), prop.value());
        }
        while (added.hasNext()) {
            prop = added.next();
            this.recordState.relAddProperty(id2, prop.propertyKeyId(), prop.value());
        }
    }

    @Override
    public void visitGraphPropertyChanges(Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
        StorageProperty prop;
        removed.each(this.recordState::graphRemoveProperty);
        while (changed.hasNext()) {
            prop = changed.next();
            this.recordState.graphChangeProperty(prop.propertyKeyId(), prop.value());
        }
        while (added.hasNext()) {
            prop = added.next();
            this.recordState.graphAddProperty(prop.propertyKeyId(), prop.value());
        }
    }

    @Override
    public void visitNodeLabelChanges(long id2, LongSet added, LongSet removed) {
        removed.each(label -> this.recordState.removeLabelFromNode(label, id2));
        added.each(label -> this.recordState.addLabelToNode(label, id2));
    }

    @Override
    public void visitAddedIndex(IndexDescriptor index) {
        StoreIndexDescriptor rule = index.withId(this.schemaStorage.newRuleId());
        this.recordState.createSchemaRule(rule);
    }

    @Override
    public void visitRemovedIndex(IndexDescriptor index) {
        StoreIndexDescriptor rule;
        Optional<String> name = index.getUserSuppliedName();
        if (name.isPresent()) {
            String indexName = name.get();
            rule = this.schemaStorage.indexGetForName(indexName);
        } else {
            rule = this.schemaStorage.indexGetForSchema(index, true);
            if (rule == null) {
                rule = this.schemaStorage.indexGetForSchema(index, false);
            }
        }
        if (rule != null) {
            this.recordState.dropSchemaRule(rule);
        }
    }

    @Override
    public void visitAddedConstraint(ConstraintDescriptor constraint) throws CreateConstraintFailureException {
        this.clearSchemaState = true;
        long constraintId = this.schemaStorage.newRuleId();
        switch (constraint.type()) {
            case UNIQUE: {
                this.visitAddedUniquenessConstraint((UniquenessConstraintDescriptor)constraint, constraintId);
                break;
            }
            case UNIQUE_EXISTS: {
                this.visitAddedNodeKeyConstraint((NodeKeyConstraintDescriptor)constraint, constraintId);
                break;
            }
            case EXISTS: {
                this.recordState.createSchemaRule(this.constraintSemantics.createExistenceConstraint(this.schemaStorage.newRuleId(), constraint));
                break;
            }
            default: {
                throw new IllegalStateException(constraint.type().toString());
            }
        }
    }

    private void visitAddedUniquenessConstraint(UniquenessConstraintDescriptor uniqueConstraint, long constraintId) {
        StoreIndexDescriptor indexRule = this.schemaStorage.indexGetForSchema(uniqueConstraint.ownedIndexDescriptor());
        this.recordState.createSchemaRule(this.constraintSemantics.createUniquenessConstraintRule(constraintId, uniqueConstraint, indexRule.getId()));
        this.recordState.setConstraintIndexOwner(indexRule, constraintId);
    }

    private void visitAddedNodeKeyConstraint(NodeKeyConstraintDescriptor uniqueConstraint, long constraintId) throws CreateConstraintFailureException {
        StoreIndexDescriptor indexRule = this.schemaStorage.indexGetForSchema(uniqueConstraint.ownedIndexDescriptor());
        this.recordState.createSchemaRule(this.constraintSemantics.createNodeKeyConstraintRule(constraintId, uniqueConstraint, indexRule.getId()));
        this.recordState.setConstraintIndexOwner(indexRule, constraintId);
    }

    @Override
    public void visitRemovedConstraint(ConstraintDescriptor constraint) {
        this.clearSchemaState = true;
        try {
            this.recordState.dropSchemaRule(this.schemaStorage.constraintsGetSingle(constraint));
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IllegalStateException("Constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
        }
        catch (DuplicateSchemaRuleException e) {
            throw new IllegalStateException("Multiple constraints found for specified label and property.");
        }
        if (constraint.enforcesUniqueness()) {
            this.visitRemovedIndex(((IndexBackedConstraintDescriptor)constraint).ownedIndexDescriptor());
        }
    }

    @Override
    public void visitCreatedLabelToken(long id2, String name) {
        this.recordState.createLabelToken(name, id2);
    }

    @Override
    public void visitCreatedPropertyKeyToken(long id2, String name) {
        this.recordState.createPropertyKeyToken(name, id2);
    }

    @Override
    public void visitCreatedRelationshipTypeToken(long id2, String name) {
        this.recordState.createRelationshipTypeToken(name, id2);
    }
}

