/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Collections;
import java.util.Set;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;

public class MultipleUnderlyingStorageExceptions
extends UnderlyingStorageException {
    public final Set<Pair<SchemaDescriptor, UnderlyingStorageException>> exceptions;

    public MultipleUnderlyingStorageExceptions(Set<Pair<SchemaDescriptor, UnderlyingStorageException>> exceptions2) {
        super(MultipleUnderlyingStorageExceptions.buildMessage(exceptions2));
        this.exceptions = Collections.unmodifiableSet(exceptions2);
        for (Pair<SchemaDescriptor, UnderlyingStorageException> exception : exceptions2) {
            this.addSuppressed(exception.other());
        }
    }

    private static String buildMessage(Set<Pair<SchemaDescriptor, UnderlyingStorageException>> exceptions2) {
        StringBuilder builder = new StringBuilder();
        builder.append("Errors when closing (flushing) index updaters:");
        for (Pair<SchemaDescriptor, UnderlyingStorageException> pair : exceptions2) {
            builder.append(String.format(" (%s) %s", pair.first().toString(), pair.other().getMessage()));
        }
        return builder.toString();
    }
}

