/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.function.Predicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreIdIterator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class Scanner {
    private Scanner() {
    }

    @SafeVarargs
    public static <R extends AbstractBaseRecord> ResourceIterable<R> scan(RecordStore<R> store, Predicate<? super R> ... filters) {
        return Scanner.scan(store, true, filters);
    }

    @SafeVarargs
    public static <R extends AbstractBaseRecord> ResourceIterable<R> scan(RecordStore<R> store, boolean forward, Predicate<? super R> ... filters) {
        return () -> new Scan(store, forward, filters);
    }

    private static class Scan<R extends AbstractBaseRecord>
    extends PrefetchingResourceIterator<R> {
        private final LongIterator ids;
        private final RecordStore<R> store;
        private final PageCursor cursor;
        private final R record;
        private final Predicate<? super R>[] filters;

        Scan(RecordStore<R> store, boolean forward, Predicate<? super R> ... filters) {
            this.filters = filters;
            this.ids = new StoreIdIterator(store, forward);
            this.store = store;
            this.cursor = store.openPageCursorForReading(0L);
            this.record = store.newRecord();
        }

        @Override
        protected R fetchNextOrNull() {
            while (this.ids.hasNext()) {
                this.store.getRecordByCursor(this.ids.next(), this.record, RecordLoad.CHECK, this.cursor);
                if (!((AbstractBaseRecord)this.record).inUse() || !this.passesFilters(this.record)) continue;
                return this.record;
            }
            return null;
        }

        private boolean passesFilters(R record) {
            for (Predicate<R> predicate : this.filters) {
                if (predicate.test(record)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void close() {
            this.cursor.close();
        }
    }
}

