/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public enum ShortArray {
    BOOLEAN(PropertyType.BOOL, 1, (Class)Boolean.class, (Class)Boolean.TYPE){

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            return 1;
        }

        @Override
        public void writeAll(Object array, int length2, int requiredBits, Bits result2) {
            if (ShortArray.isPrimitive(array)) {
                for (boolean value2 : (boolean[])array) {
                    result2.put(value2 ? 1 : 0, 1);
                }
            } else {
                Boolean[] booleanArray = (Boolean[])array;
                int n = booleanArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean value3 = booleanArray[i];
                    result2.put(value3 ? 1 : 0, 1);
                }
            }
        }

        @Override
        public ArrayValue createArray(int length2, Bits bits2, int requiredBits) {
            if (length2 == 0) {
                return Values.EMPTY_BOOLEAN_ARRAY;
            }
            boolean[] result2 = new boolean[length2];
            for (int i = 0; i < length2; ++i) {
                result2[i] = bits2.getByte(requiredBits) != 0;
            }
            return Values.booleanArray(result2);
        }

        @Override
        public ArrayValue createEmptyArray() {
            return Values.EMPTY_BOOLEAN_ARRAY;
        }
    }
    ,
    BYTE(PropertyType.BYTE, 8, (Class)Byte.class, (Class)Byte.TYPE){

        int getRequiredBits(byte value2) {
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & (long)value2) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (byte value2 : (byte[])array) {
                    highest = Math.max(this.getRequiredBits(value2), highest);
                }
            } else {
                Byte[] byteArray = (Byte[])array;
                int n = byteArray.length;
                for (int i = 0; i < n; ++i) {
                    byte value3 = byteArray[i];
                    highest = Math.max(this.getRequiredBits(value3), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length2, int requiredBits, Bits result2) {
            if (ShortArray.isPrimitive(array)) {
                for (byte b : (byte[])array) {
                    result2.put(b, requiredBits);
                }
            } else {
                Byte[] byteArray = (Byte[])array;
                int n = byteArray.length;
                for (int i = 0; i < n; ++i) {
                    byte b = byteArray[i];
                    result2.put(b, requiredBits);
                }
            }
        }

        @Override
        public ArrayValue createArray(int length2, Bits bits2, int requiredBits) {
            if (length2 == 0) {
                return Values.EMPTY_BYTE_ARRAY;
            }
            byte[] result2 = new byte[length2];
            for (int i = 0; i < length2; ++i) {
                result2[i] = bits2.getByte(requiredBits);
            }
            return Values.byteArray(result2);
        }

        @Override
        public ArrayValue createEmptyArray() {
            return Values.EMPTY_BYTE_ARRAY;
        }
    }
    ,
    SHORT(PropertyType.SHORT, 16, (Class)Short.class, (Class)Short.TYPE){

        int getRequiredBits(short value2) {
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & (long)value2) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (short value2 : (short[])array) {
                    highest = Math.max(this.getRequiredBits(value2), highest);
                }
            } else {
                Short[] shortArray = (Short[])array;
                int n = shortArray.length;
                for (int i = 0; i < n; ++i) {
                    short value3 = shortArray[i];
                    highest = Math.max(this.getRequiredBits(value3), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length2, int requiredBits, Bits result2) {
            if (ShortArray.isPrimitive(array)) {
                for (short value2 : (short[])array) {
                    result2.put(value2, requiredBits);
                }
            } else {
                Short[] shortArray = (Short[])array;
                int n = shortArray.length;
                for (int i = 0; i < n; ++i) {
                    short value3 = shortArray[i];
                    result2.put(value3, requiredBits);
                }
            }
        }

        @Override
        public ArrayValue createArray(int length2, Bits bits2, int requiredBits) {
            if (length2 == 0) {
                return Values.EMPTY_SHORT_ARRAY;
            }
            short[] result2 = new short[length2];
            for (int i = 0; i < length2; ++i) {
                result2[i] = bits2.getShort(requiredBits);
            }
            return Values.shortArray(result2);
        }

        @Override
        public ArrayValue createEmptyArray() {
            return Values.EMPTY_SHORT_ARRAY;
        }
    }
    ,
    CHAR(PropertyType.CHAR, 16, (Class)Character.class, (Class)Character.TYPE){

        int getRequiredBits(char value2) {
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & (long)value2) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (char value2 : (char[])array) {
                    highest = Math.max(this.getRequiredBits(value2), highest);
                }
            } else {
                Character[] characterArray = (Character[])array;
                int n = characterArray.length;
                for (int i = 0; i < n; ++i) {
                    char value3 = characterArray[i].charValue();
                    highest = Math.max(this.getRequiredBits(value3), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length2, int requiredBits, Bits result2) {
            if (ShortArray.isPrimitive(array)) {
                for (char value2 : (char[])array) {
                    result2.put(value2, requiredBits);
                }
            } else {
                Character[] characterArray = (Character[])array;
                int n = characterArray.length;
                for (int i = 0; i < n; ++i) {
                    char value3 = characterArray[i].charValue();
                    result2.put(value3, requiredBits);
                }
            }
        }

        @Override
        public ArrayValue createArray(int length2, Bits bits2, int requiredBits) {
            if (length2 == 0) {
                return Values.EMPTY_CHAR_ARRAY;
            }
            char[] result2 = new char[length2];
            for (int i = 0; i < length2; ++i) {
                result2[i] = (char)bits2.getShort(requiredBits);
            }
            return Values.charArray(result2);
        }

        @Override
        public ArrayValue createEmptyArray() {
            return Values.EMPTY_CHAR_ARRAY;
        }
    }
    ,
    INT(PropertyType.INT, 32, (Class)Integer.class, (Class)Integer.TYPE){

        int getRequiredBits(int value2) {
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & (long)value2) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (int value2 : (int[])array) {
                    highest = Math.max(this.getRequiredBits(value2), highest);
                }
            } else {
                Integer[] integerArray = (Integer[])array;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int value3 = integerArray[i];
                    highest = Math.max(this.getRequiredBits(value3), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length2, int requiredBits, Bits result2) {
            if (ShortArray.isPrimitive(array)) {
                for (int value2 : (int[])array) {
                    result2.put(value2, requiredBits);
                }
            } else {
                Integer[] integerArray = (Integer[])array;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int value3 = integerArray[i];
                    result2.put(value3, requiredBits);
                }
            }
        }

        @Override
        public ArrayValue createArray(int length2, Bits bits2, int requiredBits) {
            if (length2 == 0) {
                return Values.EMPTY_INT_ARRAY;
            }
            int[] result2 = new int[length2];
            for (int i = 0; i < length2; ++i) {
                result2[i] = bits2.getInt(requiredBits);
            }
            return Values.intArray(result2);
        }

        @Override
        public ArrayValue createEmptyArray() {
            return Values.EMPTY_INT_ARRAY;
        }
    }
    ,
    LONG(PropertyType.LONG, 64, (Class)Long.class, (Class)Long.TYPE){

        @Override
        public int getRequiredBits(long value2) {
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & value2) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (long value2 : (long[])array) {
                    highest = Math.max(this.getRequiredBits(value2), highest);
                }
            } else {
                Long[] longArray = (Long[])array;
                int n = longArray.length;
                for (int i = 0; i < n; ++i) {
                    long value3 = longArray[i];
                    highest = Math.max(this.getRequiredBits(value3), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length2, int requiredBits, Bits result2) {
            if (ShortArray.isPrimitive(array)) {
                for (long value2 : (long[])array) {
                    result2.put(value2, requiredBits);
                }
            } else {
                Long[] longArray = (Long[])array;
                int n = longArray.length;
                for (int i = 0; i < n; ++i) {
                    long value3 = longArray[i];
                    result2.put(value3, requiredBits);
                }
            }
        }

        @Override
        public ArrayValue createArray(int length2, Bits bits2, int requiredBits) {
            if (length2 == 0) {
                return Values.EMPTY_LONG_ARRAY;
            }
            long[] result2 = new long[length2];
            for (int i = 0; i < length2; ++i) {
                result2[i] = bits2.getLong(requiredBits);
            }
            return Values.longArray(result2);
        }

        @Override
        public ArrayValue createEmptyArray() {
            return Values.EMPTY_LONG_ARRAY;
        }
    }
    ,
    FLOAT(PropertyType.FLOAT, 32, (Class)Float.class, (Class)Float.TYPE){

        int getRequiredBits(float value2) {
            int v = Float.floatToIntBits(value2);
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & (long)v) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (float value2 : (float[])array) {
                    highest = Math.max(this.getRequiredBits(value2), highest);
                }
            } else {
                Float[] floatArray = (Float[])array;
                int n = floatArray.length;
                for (int i = 0; i < n; ++i) {
                    float value3 = floatArray[i].floatValue();
                    highest = Math.max(this.getRequiredBits(value3), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length2, int requiredBits, Bits result2) {
            if (ShortArray.isPrimitive(array)) {
                for (float value2 : (float[])array) {
                    result2.put(Float.floatToIntBits(value2), requiredBits);
                }
            } else {
                Float[] floatArray = (Float[])array;
                int n = floatArray.length;
                for (int i = 0; i < n; ++i) {
                    float value3 = floatArray[i].floatValue();
                    result2.put(Float.floatToIntBits(value3), requiredBits);
                }
            }
        }

        @Override
        public void writeAll(Object array, byte[] result2, int offset) {
            if (ShortArray.isPrimitive(array)) {
                float[] values2 = (float[])array;
                for (int i = 0; i < values2.length; ++i) {
                    this.writeFloat(values2[i], result2, offset + i * 4);
                }
            } else {
                Float[] values3 = (Float[])array;
                for (int i = 0; i < values3.length; ++i) {
                    this.writeFloat(values3[i].floatValue(), result2, offset + i * 4);
                }
            }
        }

        private void writeFloat(float floaValue, byte[] result2, int offset) {
            long value2 = Float.floatToIntBits(floaValue);
            for (int b = 0; b < 4; ++b) {
                result2[offset + b] = (byte)(value2 >> b * 8 & 0xFFL);
            }
        }

        @Override
        public ArrayValue createArray(int length2, Bits bits2, int requiredBits) {
            if (length2 == 0) {
                return Values.EMPTY_FLOAT_ARRAY;
            }
            float[] result2 = new float[length2];
            for (int i = 0; i < length2; ++i) {
                result2[i] = Float.intBitsToFloat(bits2.getInt(requiredBits));
            }
            return Values.floatArray(result2);
        }

        @Override
        public ArrayValue createEmptyArray() {
            return Values.EMPTY_FLOAT_ARRAY;
        }
    }
    ,
    DOUBLE(PropertyType.DOUBLE, 64, (Class)Double.class, (Class)Double.TYPE){

        int getRequiredBits(double value2) {
            long v = Double.doubleToLongBits(value2);
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & v) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (double value2 : (double[])array) {
                    highest = Math.max(this.getRequiredBits(value2), highest);
                }
            } else {
                Double[] doubleArray = (Double[])array;
                int n = doubleArray.length;
                for (int i = 0; i < n; ++i) {
                    double value3 = doubleArray[i];
                    highest = Math.max(this.getRequiredBits(value3), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length2, int requiredBits, Bits result2) {
            if (ShortArray.isPrimitive(array)) {
                for (double value2 : (double[])array) {
                    result2.put(Double.doubleToLongBits(value2), requiredBits);
                }
            } else {
                Double[] doubleArray = (Double[])array;
                int n = doubleArray.length;
                for (int i = 0; i < n; ++i) {
                    double value3 = doubleArray[i];
                    result2.put(Double.doubleToLongBits(value3), requiredBits);
                }
            }
        }

        @Override
        public void writeAll(Object array, byte[] result2, int offset) {
            if (ShortArray.isPrimitive(array)) {
                double[] values2 = (double[])array;
                for (int i = 0; i < values2.length; ++i) {
                    this.writeDouble(values2[i], result2, offset + i * 8);
                }
            } else {
                Double[] values3 = (Double[])array;
                for (int i = 0; i < values3.length; ++i) {
                    this.writeDouble(values3[i], result2, offset + i * 8);
                }
            }
        }

        private void writeDouble(double doubleValue, byte[] result2, int offset) {
            long value2 = Double.doubleToLongBits(doubleValue);
            for (int b = 0; b < 8; ++b) {
                result2[offset + b] = (byte)(value2 >> b * 8 & 0xFFL);
            }
        }

        @Override
        public ArrayValue createArray(int length2, Bits bits2, int requiredBits) {
            if (length2 == 0) {
                return Values.EMPTY_DOUBLE_ARRAY;
            }
            double[] result2 = new double[length2];
            for (int i = 0; i < length2; ++i) {
                result2[i] = Double.longBitsToDouble(bits2.getLong(requiredBits));
            }
            return Values.doubleArray(result2);
        }

        @Override
        public ArrayValue createEmptyArray() {
            return Values.EMPTY_DOUBLE_ARRAY;
        }
    };

    private static final ShortArray[] TYPES;
    private static final Map<Class<?>, ShortArray> all;
    final int maxBits;
    private final Class<?> boxedClass;
    private final Class<?> primitiveClass;
    private final PropertyType type;

    private static boolean isPrimitive(Object array) {
        return array.getClass().getComponentType().isPrimitive();
    }

    private ShortArray(PropertyType type, int maxBits, Class<?> boxedClass2, Class<?> primitiveClass) {
        this.type = type;
        this.maxBits = maxBits;
        this.boxedClass = boxedClass2;
        this.primitiveClass = primitiveClass;
    }

    public int intValue() {
        return this.type.intValue();
    }

    public abstract ArrayValue createArray(int var1, Bits var2, int var3);

    public static boolean encode(int keyId, Object array, PropertyBlock target, int payloadSizeInBytes) {
        int arrayLength = Array.getLength(array);
        if (arrayLength > 63) {
            return false;
        }
        ShortArray type = ShortArray.typeOf(array);
        if (type == null) {
            return false;
        }
        int requiredBits = type.calculateRequiredBitsForArray(array, arrayLength);
        if (!ShortArray.willFit(requiredBits, arrayLength, payloadSizeInBytes)) {
            return false;
        }
        int numberOfBytes = ShortArray.calculateNumberOfBlocksUsed(arrayLength, requiredBits) * 8;
        if (Bits.requiredLongs(numberOfBytes) > PropertyType.getPayloadSizeLongs()) {
            return false;
        }
        Bits result2 = Bits.bits(numberOfBytes);
        ShortArray.writeHeader(keyId, type, arrayLength, requiredBits, result2);
        type.writeAll(array, arrayLength, requiredBits, result2);
        target.setValueBlocks(result2.getLongs());
        return true;
    }

    private static void writeHeader(int keyId, ShortArray type, int arrayLength, int requiredBits, Bits result2) {
        result2.put(keyId, 24);
        result2.put(PropertyType.SHORT_ARRAY.intValue(), 4);
        result2.put(type.type.intValue(), 4);
        result2.put(arrayLength, 6);
        result2.put(requiredBits, 6);
    }

    public static Value decode(PropertyBlock block) {
        Bits bits2 = Bits.bitsFromLongs(Arrays.copyOf(block.getValueBlocks(), block.getValueBlocks().length));
        return ShortArray.decode(bits2);
    }

    public static Value decode(Bits bits2) {
        bits2.getInt(24);
        bits2.getByte(4);
        byte typeId = bits2.getByte(4);
        byte arrayLength = bits2.getByte(6);
        int requiredBits = bits2.getByte(6);
        if (requiredBits == 0) {
            requiredBits = 64;
        }
        ShortArray type = ShortArray.typeOf(typeId);
        return type.createArray(arrayLength, bits2, requiredBits);
    }

    private static boolean willFit(int requiredBits, int arrayLength, int payloadSizeInBytes) {
        int totalBitsRequired = requiredBits * arrayLength;
        int maxBits = payloadSizeInBytes * 8 - 24 - 4 - 4 - 6 - 6;
        return totalBitsRequired <= maxBits;
    }

    public int calculateRequiredBitsForArray(Object array, int arrayLength) {
        if (arrayLength == 0) {
            return 0;
        }
        return this.getRequiredBits(array, arrayLength);
    }

    public int getRequiredBits(long value2) {
        int highest = 1;
        long mask = 1L;
        int i = 1;
        while (i <= this.maxBits) {
            if ((mask & value2) != 0L) {
                highest = i;
            }
            ++i;
            mask <<= 1;
        }
        return highest;
    }

    abstract int getRequiredBits(Object var1, int var2);

    public static ShortArray typeOf(byte typeId) {
        return TYPES[typeId - 1];
    }

    public static ShortArray typeOf(Object array) {
        return all.get(array.getClass().getComponentType());
    }

    public static int calculateNumberOfBlocksUsed(long firstBlock) {
        int highInt = (int)(firstBlock >>> 32);
        int arrayLength = highInt & 0x3F;
        int requiredBits = (highInt >>>= 6) & 0x3F;
        if (requiredBits == 0) {
            requiredBits = 64;
        }
        return ShortArray.calculateNumberOfBlocksUsed(arrayLength, requiredBits);
    }

    public static int calculateNumberOfBlocksUsed(int arrayLength, int requiredBits) {
        int bitsForItems = arrayLength * requiredBits;
        int totalBits = 44 + bitsForItems;
        int result2 = (totalBits - 1) / 64 + 1;
        return result2;
    }

    public abstract void writeAll(Object var1, int var2, int var3, Bits var4);

    public void writeAll(Object array, byte[] result2, int offset) {
        throw new IllegalStateException("Types that skip bit compaction should implement this method");
    }

    public abstract ArrayValue createEmptyArray();

    static {
        TYPES = ShortArray.values();
        all = new IdentityHashMap(TYPES.length * 2);
        for (ShortArray shortArray : TYPES) {
            all.put(shortArray.primitiveClass, shortArray);
            all.put(shortArray.boxedClass, shortArray);
        }
    }
}

