/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;

public enum StoreType {
    NODE_LABEL(DatabaseFile.NODE_LABEL_STORE, true, false){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createNodeLabelStore();
        }
    }
    ,
    NODE(DatabaseFile.NODE_STORE, true, false){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createNodeStore();
        }
    }
    ,
    PROPERTY_KEY_TOKEN_NAME(DatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE, true, true){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createPropertyKeyTokenNamesStore();
        }
    }
    ,
    PROPERTY_KEY_TOKEN(DatabaseFile.PROPERTY_KEY_TOKEN_STORE, true, true){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createPropertyKeyTokenStore();
        }
    }
    ,
    PROPERTY_STRING(DatabaseFile.PROPERTY_STRING_STORE, true, false){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createPropertyStringStore();
        }
    }
    ,
    PROPERTY_ARRAY(DatabaseFile.PROPERTY_ARRAY_STORE, true, false){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createPropertyArrayStore();
        }
    }
    ,
    PROPERTY(DatabaseFile.PROPERTY_STORE, true, false){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createPropertyStore();
        }
    }
    ,
    RELATIONSHIP(DatabaseFile.RELATIONSHIP_STORE, true, false){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createRelationshipStore();
        }
    }
    ,
    RELATIONSHIP_TYPE_TOKEN_NAME(DatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, true, true){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createRelationshipTypeTokenNamesStore();
        }
    }
    ,
    RELATIONSHIP_TYPE_TOKEN(DatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE, true, true){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createRelationshipTypeTokenStore();
        }
    }
    ,
    LABEL_TOKEN_NAME(DatabaseFile.LABEL_TOKEN_NAMES_STORE, true, true){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createLabelTokenNamesStore();
        }
    }
    ,
    LABEL_TOKEN(DatabaseFile.LABEL_TOKEN_STORE, true, true){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createLabelTokenStore();
        }
    }
    ,
    SCHEMA(DatabaseFile.SCHEMA_STORE, true, true){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createSchemaStore();
        }
    }
    ,
    RELATIONSHIP_GROUP(DatabaseFile.RELATIONSHIP_GROUP_STORE, true, false){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createRelationshipGroupStore();
        }
    }
    ,
    COUNTS(DatabaseFile.COUNTS_STORES, false, false){

        @Override
        public CountsTracker open(NeoStores neoStores) {
            return neoStores.createCountStore();
        }

        @Override
        void close(Object object) {
            try {
                ((CountsTracker)object).shutdown();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
        }
    }
    ,
    META_DATA(DatabaseFile.METADATA_STORE, true, true){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createMetadataStore();
        }
    };

    private final boolean recordStore;
    private final boolean limitedIdStore;
    private final DatabaseFile databaseFile;

    private StoreType(DatabaseFile databaseFile, boolean recordStore, boolean limitedIdStore) {
        this.databaseFile = databaseFile;
        this.recordStore = recordStore;
        this.limitedIdStore = limitedIdStore;
    }

    abstract Object open(NeoStores var1);

    public boolean isRecordStore() {
        return this.recordStore;
    }

    public boolean isLimitedIdStore() {
        return this.limitedIdStore;
    }

    public DatabaseFile getDatabaseFile() {
        return this.databaseFile;
    }

    void close(Object object) {
        ((CommonAbstractStore)object).close();
    }

    public static Optional<StoreType> typeOf(DatabaseFile databaseFile) {
        StoreType[] values2;
        Objects.requireNonNull(databaseFile);
        for (StoreType value2 : values2 = StoreType.values()) {
            if (!value2.getDatabaseFile().equals((Object)databaseFile)) continue;
            return Optional.of(value2);
        }
        return Optional.empty();
    }
}

