/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import org.neo4j.kernel.impl.store.kvstore.HeaderField;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

final class FileVersion {
    static final long INITIAL_TX_ID = 1L;
    static final int INITIAL_MINOR_VERSION = 0;
    final long txId;
    final long minorVersion;
    static final HeaderField<FileVersion> FILE_VERSION = new HeaderField<FileVersion>(){

        @Override
        public FileVersion read(ReadableBuffer header) {
            return new FileVersion(header.getLong(0), header.getLong(8));
        }

        @Override
        public void write(FileVersion the, WritableBuffer header) {
            header.putLong(0, the.txId);
            header.putLong(8, the.minorVersion);
        }

        public String toString() {
            return "<Transaction ID>";
        }
    };

    FileVersion(long txId) {
        this(txId, 0L);
    }

    public FileVersion update(long txId) {
        return new FileVersion(txId, this.txId == txId ? this.minorVersion + 1L : 0L);
    }

    public String toString() {
        return String.format("FileVersion[txId=%d, minorVersion=%d]", this.txId, this.minorVersion);
    }

    FileVersion(long txId, long minorVersion) {
        this.txId = txId;
        this.minorVersion = minorVersion;
    }
}

