/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.util.function.Function;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.format.BaseRecordFormat;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public abstract class BaseOneByteHeaderRecordFormat<RECORD extends AbstractBaseRecord>
extends BaseRecordFormat<RECORD> {
    protected static final int HEADER_SIZE = 1;
    private final int inUseBitMaskForFirstByte;

    protected BaseOneByteHeaderRecordFormat(Function<StoreHeader, Integer> recordSize, int recordHeaderSize, int inUseBitMaskForFirstByte, int idBits) {
        super(recordSize, recordHeaderSize, idBits);
        this.inUseBitMaskForFirstByte = inUseBitMaskForFirstByte;
    }

    protected void markAsUnused(PageCursor cursor) {
        byte inUseByte = cursor.getByte(cursor.getOffset());
        inUseByte = (byte)(inUseByte & ~this.inUseBitMaskForFirstByte);
        cursor.putByte(inUseByte);
    }

    @Override
    public boolean isInUse(PageCursor cursor) {
        return this.isInUse(cursor.getByte(cursor.getOffset()));
    }

    protected boolean isInUse(byte headerByte) {
        return BaseOneByteHeaderRecordFormat.has(headerByte, this.inUseBitMaskForFirstByte);
    }

    protected static boolean has(long headerByte, int bitMask) {
        return (headerByte & (long)bitMask) != 0L;
    }

    protected static byte set(byte headerByte, int bitMask, boolean value2) {
        return (byte)(value2 ? headerByte | bitMask : headerByte);
    }
}

