/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_2;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_4;
import org.neo4j.logging.LogProvider;

public class RecordFormatSelector {
    private static final RecordFormats DEFAULT_FORMAT = Standard.LATEST_RECORD_FORMATS;
    private static final List<RecordFormats> KNOWN_FORMATS = Arrays.asList(StandardV2_3.RECORD_FORMATS, StandardV3_0.RECORD_FORMATS, StandardV3_2.RECORD_FORMATS, StandardV3_4.RECORD_FORMATS);

    private RecordFormatSelector() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    @Nonnull
    public static RecordFormats defaultFormat() {
        return DEFAULT_FORMAT;
    }

    @Nonnull
    public static RecordFormats selectForVersion(String storeVersion) {
        for (RecordFormats format2 : RecordFormatSelector.allFormats()) {
            if (!format2.storeVersion().equals(storeVersion)) continue;
            return format2;
        }
        throw new IllegalArgumentException("Unknown store version '" + storeVersion + "'");
    }

    @Nonnull
    public static RecordFormats selectForConfig(Config config, LogProvider logProvider) {
        String recordFormat = RecordFormatSelector.configuredRecordFormat(config);
        if (StringUtils.isEmpty(recordFormat)) {
            RecordFormatSelector.info(logProvider, "Record format not configured, selected default: " + RecordFormatSelector.defaultFormat());
            return RecordFormatSelector.defaultFormat();
        }
        RecordFormats format2 = RecordFormatSelector.selectSpecificFormat(recordFormat);
        RecordFormatSelector.info(logProvider, "Selected record format based on config: " + format2);
        return format2;
    }

    @Nullable
    static RecordFormats selectForStore(DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, LogProvider logProvider) {
        File neoStoreFile = databaseLayout.metadataStore();
        if (fs.fileExists(neoStoreFile)) {
            try {
                long value2 = MetaDataStore.getRecord(pageCache, neoStoreFile, MetaDataStore.Position.STORE_VERSION);
                if (value2 != -1L) {
                    String storeVersion = MetaDataStore.versionLongToString(value2);
                    for (RecordFormats format2 : RecordFormatSelector.allFormats()) {
                        if (!format2.storeVersion().equals(storeVersion)) continue;
                        RecordFormatSelector.info(logProvider, "Selected " + format2 + " record format from store " + databaseLayout.databaseDirectory());
                        return format2;
                    }
                }
            }
            catch (IOException e) {
                RecordFormatSelector.info(logProvider, "Unable to read store format: " + e.getMessage());
            }
        }
        return null;
    }

    @Nonnull
    public static RecordFormats selectForStoreOrConfig(Config config, DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, LogProvider logProvider) {
        boolean storeWithFormatExists;
        RecordFormats configuredFormat = RecordFormatSelector.loadRecordFormat(RecordFormatSelector.configuredRecordFormat(config));
        boolean formatConfigured = configuredFormat != null;
        RecordFormats currentFormat = RecordFormatSelector.selectForStore(databaseLayout, fs, pageCache, logProvider);
        boolean bl = storeWithFormatExists = currentFormat != null;
        if (formatConfigured && storeWithFormatExists) {
            if (currentFormat.getFormatFamily().equals(configuredFormat.getFormatFamily()) && currentFormat.generation() == configuredFormat.generation()) {
                RecordFormatSelector.info(logProvider, "Configured format matches format in the store. Selected: " + currentFormat);
                return currentFormat;
            }
            throw new IllegalArgumentException(String.format("Configured format '%s' is different from the actual format in the store '%s'", configuredFormat, currentFormat));
        }
        if (!formatConfigured && storeWithFormatExists) {
            RecordFormatSelector.info(logProvider, "Format not configured. Selected format from the store: " + currentFormat);
            return currentFormat;
        }
        if (formatConfigured) {
            RecordFormatSelector.info(logProvider, "Selected configured format: " + configuredFormat);
            return configuredFormat;
        }
        return DEFAULT_FORMAT;
    }

    public static boolean isStoreAndConfigFormatsCompatible(Config config, DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, LogProvider logProvider) {
        RecordFormats configuredFormat = RecordFormatSelector.loadRecordFormat(RecordFormatSelector.configuredRecordFormat(config));
        RecordFormats currentFormat = RecordFormatSelector.selectForStore(databaseLayout, fs, pageCache, logProvider);
        return configuredFormat == null || currentFormat == null || currentFormat.getFormatFamily().equals(configuredFormat.getFormatFamily()) && currentFormat.generation() == configuredFormat.generation();
    }

    @Nonnull
    public static RecordFormats selectNewestFormat(Config config, DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, LogProvider logProvider) {
        boolean formatConfigured = StringUtils.isNotEmpty(RecordFormatSelector.configuredRecordFormat(config));
        if (formatConfigured) {
            return RecordFormatSelector.selectForConfig(config, logProvider);
        }
        RecordFormats result2 = RecordFormatSelector.selectForStore(databaseLayout, fs, pageCache, logProvider);
        if (result2 == null) {
            RecordFormatSelector.info(logProvider, "Selected format '" + DEFAULT_FORMAT + "' for the new store");
            result2 = DEFAULT_FORMAT;
        } else if (FormatFamily.isHigherFamilyFormat(DEFAULT_FORMAT, result2) || FormatFamily.isSameFamily(result2, DEFAULT_FORMAT) && result2.generation() < DEFAULT_FORMAT.generation()) {
            RecordFormatSelector.info(logProvider, "Selected format '" + DEFAULT_FORMAT + "' for existing store with format '" + result2 + "'");
            result2 = DEFAULT_FORMAT;
        }
        return result2;
    }

    @Nonnull
    public static Optional<RecordFormats> findSuccessor(@Nonnull RecordFormats format2) {
        return StreamSupport.stream(RecordFormatSelector.allFormats().spliterator(), false).filter(candidate -> FormatFamily.isSameFamily(format2, candidate)).filter(candidate -> candidate.generation() > format2.generation()).reduce((a, b) -> a.generation() < b.generation() ? a : b);
    }

    public static Iterable<RecordFormats> allFormats() {
        Iterable<RecordFormats.Factory> loadableFormatFactories = Service.load(RecordFormats.Factory.class);
        Iterable<RecordFormats> loadableFormats = Iterables.map(RecordFormats.Factory::newInstance, loadableFormatFactories);
        return Iterables.concat(KNOWN_FORMATS, loadableFormats);
    }

    @Nonnull
    private static RecordFormats selectSpecificFormat(String recordFormat) {
        RecordFormats formats = RecordFormatSelector.loadRecordFormat(recordFormat);
        if (formats == null) {
            throw new IllegalArgumentException("No record format found with the name '" + recordFormat + "'.");
        }
        return formats;
    }

    @Nullable
    private static RecordFormats loadRecordFormat(String recordFormat) {
        if (StringUtils.isNotEmpty(recordFormat)) {
            if ("standard".equals(recordFormat)) {
                return Standard.LATEST_RECORD_FORMATS;
            }
            for (RecordFormats knownFormat : KNOWN_FORMATS) {
                if (!recordFormat.equals(knownFormat.name())) continue;
                return knownFormat;
            }
            RecordFormats.Factory formatFactory = Service.loadSilently(RecordFormats.Factory.class, recordFormat);
            if (formatFactory != null) {
                return formatFactory.newInstance();
            }
        }
        return null;
    }

    private static void info(LogProvider logProvider, String message) {
        logProvider.getLog(RecordFormatSelector.class).info(message);
    }

    @Nonnull
    private static String configuredRecordFormat(Config config) {
        return config.get(GraphDatabaseSettings.record_format);
    }
}

