/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.standard;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.BaseOneByteHeaderRecordFormat;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class MetaDataRecordFormat
extends BaseOneByteHeaderRecordFormat<MetaDataRecord> {
    public static final int RECORD_SIZE = 9;
    public static final long FIELD_NOT_PRESENT = -1L;
    private static final int ID_BITS = 32;

    public MetaDataRecordFormat() {
        super(MetaDataRecordFormat.fixedRecordSize(9), 0, 1, 32);
    }

    @Override
    public MetaDataRecord newRecord() {
        return new MetaDataRecord();
    }

    @Override
    public void read(MetaDataRecord record, PageCursor cursor, RecordLoad mode, int recordSize) {
        MetaDataStore.Position[] values2;
        int id2 = record.getIntId();
        if (id2 >= (values2 = MetaDataStore.Position.values()).length) {
            record.initialize(false, -1L);
            return;
        }
        MetaDataStore.Position position2 = values2[id2];
        int offset = position2.id() * recordSize;
        cursor.setOffset(offset);
        boolean inUse = cursor.getByte() == Record.IN_USE.byteValue();
        long value2 = inUse ? cursor.getLong() : -1L;
        record.initialize(inUse, value2);
    }

    @Override
    public void write(MetaDataRecord record, PageCursor cursor, int recordSize) {
        assert (record.inUse());
        cursor.putByte(Record.IN_USE.byteValue());
        cursor.putLong(record.getValue());
    }
}

