/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;

public class BatchingIdSequence
implements IdSequence {
    private final long startId;
    private long nextId;

    public BatchingIdSequence() {
        this(0L);
    }

    public BatchingIdSequence(long startId) {
        this.startId = startId;
        this.nextId = startId;
    }

    @Override
    public long nextId() {
        long result2 = this.peek();
        ++this.nextId;
        return result2;
    }

    @Override
    public IdRange nextIdBatch(int size2) {
        while (IdValidator.hasReservedIdInRange(this.nextId, this.nextId + (long)size2)) {
            this.nextId += (long)size2;
        }
        long startId = this.nextId;
        this.nextId += (long)size2;
        return new IdRange(PrimitiveLongCollections.EMPTY_LONG_ARRAY, startId, size2);
    }

    public void reset() {
        this.nextId = this.startId;
    }

    public void set(long nextId) {
        this.nextId = nextId;
    }

    public long peek() {
        if (IdValidator.isReservedId(this.nextId)) {
            ++this.nextId;
        }
        return this.nextId;
    }
}

