/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.kvstore.ProgressiveFormat;
import org.neo4j.kernel.impl.store.kvstore.RotationMonitor;
import org.neo4j.kernel.impl.store.kvstore.RotationStrategy;

@Inherited
@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Rotation {
    public Strategy value();

    public static enum Strategy {
        LEFT_RIGHT{

            @Override
            RotationStrategy create(FileSystemAbstraction fs, PageCache pages, ProgressiveFormat format2, RotationMonitor monitor, DatabaseLayout databaseLayout) {
                File left2 = databaseLayout.countStoreA();
                File right2 = databaseLayout.countStoreB();
                return new RotationStrategy.LeftRight(fs, pages, format2, monitor, left2, right2);
            }
        }
        ,
        INCREMENTING{

            @Override
            RotationStrategy create(FileSystemAbstraction fs, PageCache pages, ProgressiveFormat format2, RotationMonitor monitor, DatabaseLayout databaseLayout) {
                return new RotationStrategy.Incrementing(fs, pages, format2, monitor, databaseLayout);
            }
        };


        abstract RotationStrategy create(FileSystemAbstraction var1, PageCache var2, ProgressiveFormat var3, RotationMonitor var4, DatabaseLayout var5);
    }
}

