/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class ConstraintRule
implements SchemaRule,
ConstraintDescriptor.Supplier {
    private final Long ownedIndex;
    private final String name;
    private final long id;
    private final ConstraintDescriptor descriptor;

    public static ConstraintRule constraintRule(long id2, ConstraintDescriptor descriptor) {
        return new ConstraintRule(id2, descriptor, null);
    }

    public static ConstraintRule constraintRule(long id2, IndexBackedConstraintDescriptor descriptor, long ownedIndexRule) {
        return new ConstraintRule(id2, descriptor, ownedIndexRule);
    }

    public static ConstraintRule constraintRule(long id2, ConstraintDescriptor descriptor, String name) {
        return new ConstraintRule(id2, descriptor, null, name);
    }

    public static ConstraintRule constraintRule(long id2, IndexBackedConstraintDescriptor descriptor, long ownedIndexRule, String name) {
        return new ConstraintRule(id2, descriptor, ownedIndexRule, name);
    }

    ConstraintRule(long id2, ConstraintDescriptor descriptor, Long ownedIndex) {
        this(id2, descriptor, ownedIndex, null);
    }

    ConstraintRule(long id2, ConstraintDescriptor descriptor, Long ownedIndex, String name) {
        this.id = id2;
        this.descriptor = descriptor;
        this.ownedIndex = ownedIndex;
        this.name = SchemaRule.nameOrDefault(name, "constraint_" + id2);
    }

    public String toString() {
        return "ConstraintRule[id=" + this.id + ", descriptor=" + this.descriptor.userDescription(SchemaUtil.idTokenNameLookup) + ", ownedIndex=" + this.ownedIndex + "]";
    }

    @Override
    public SchemaDescriptor schema() {
        return this.descriptor.schema();
    }

    @Override
    public ConstraintDescriptor getConstraintDescriptor() {
        return this.descriptor;
    }

    public long getOwnedIndex() {
        if (this.ownedIndex == null) {
            throw new IllegalStateException("This constraint does not own an index.");
        }
        return this.ownedIndex;
    }

    public boolean equals(Object o) {
        if (o instanceof ConstraintRule) {
            ConstraintRule that = (ConstraintRule)o;
            return this.descriptor.equals(that.descriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

