/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.Record;

public class PropertyRecord
extends AbstractBaseRecord
implements Iterable<PropertyBlock> {
    private static final byte TYPE_NODE = 1;
    private static final byte TYPE_REL = 2;
    private long nextProp;
    private long prevProp;
    private final long[] blocks = new long[PropertyType.getPayloadSizeLongs()];
    private int blocksCursor;
    private final PropertyBlock[] blockRecords = new PropertyBlock[PropertyType.getPayloadSizeLongs()];
    private boolean blocksLoaded;
    private int blockRecordsCursor;
    private long entityId;
    private byte entityType;
    private List<DynamicRecord> deletedRecords;

    public PropertyRecord(long id2) {
        super(id2);
    }

    public PropertyRecord(long id2, PrimitiveRecord primitive) {
        super(id2);
        primitive.setIdTo(this);
    }

    public PropertyRecord initialize(boolean inUse, long prevProp, long nextProp) {
        super.initialize(inUse);
        this.prevProp = prevProp;
        this.nextProp = nextProp;
        this.deletedRecords = null;
        this.blocksCursor = 0;
        this.blockRecordsCursor = 0;
        this.blocksLoaded = false;
        return this;
    }

    @Override
    public void clear() {
        super.initialize(false);
        this.entityId = -1L;
        this.entityType = 0;
        this.prevProp = Record.NO_PREVIOUS_PROPERTY.intValue();
        this.nextProp = Record.NO_NEXT_PROPERTY.intValue();
        this.deletedRecords = null;
        this.blocksCursor = 0;
        this.blockRecordsCursor = 0;
        this.blocksLoaded = false;
    }

    public void setNodeId(long nodeId) {
        this.entityType = 1;
        this.entityId = nodeId;
    }

    public void setRelId(long relId) {
        this.entityType = (byte)2;
        this.entityId = relId;
    }

    public boolean isNodeSet() {
        return this.entityType == 1;
    }

    public boolean isRelSet() {
        return this.entityType == 2;
    }

    public long getNodeId() {
        if (this.isNodeSet()) {
            return this.entityId;
        }
        return -1L;
    }

    public long getRelId() {
        if (this.isRelSet()) {
            return this.entityId;
        }
        return -1L;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public int size() {
        this.ensureBlocksLoaded();
        int result2 = 0;
        for (int i = 0; i < this.blockRecordsCursor; ++i) {
            result2 += this.blockRecords[i].getSize();
        }
        return result2;
    }

    public int numberOfProperties() {
        this.ensureBlocksLoaded();
        return this.blockRecordsCursor;
    }

    @Override
    public Iterator<PropertyBlock> iterator() {
        this.ensureBlocksLoaded();
        return new Iterator<PropertyBlock>(){
            private int blockRecordsIteratorCursor;
            private boolean canRemoveFromIterator;

            @Override
            public boolean hasNext() {
                return this.blockRecordsIteratorCursor < PropertyRecord.this.blockRecordsCursor;
            }

            @Override
            public PropertyBlock next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.canRemoveFromIterator = true;
                return PropertyRecord.this.blockRecords[this.blockRecordsIteratorCursor++];
            }

            @Override
            public void remove() {
                if (!this.canRemoveFromIterator) {
                    throw new IllegalStateException("cursor:" + this.blockRecordsIteratorCursor + " canRemove:" + this.canRemoveFromIterator);
                }
                if (--PropertyRecord.this.blockRecordsCursor > --this.blockRecordsIteratorCursor) {
                    ((PropertyRecord)PropertyRecord.this).blockRecords[this.blockRecordsIteratorCursor] = PropertyRecord.this.blockRecords[PropertyRecord.this.blockRecordsCursor];
                }
                this.canRemoveFromIterator = false;
            }
        };
    }

    public List<DynamicRecord> getDeletedRecords() {
        return this.deletedRecords != null ? this.deletedRecords : Collections.emptyList();
    }

    public void addDeletedRecord(DynamicRecord record) {
        assert (!record.inUse());
        if (this.deletedRecords == null) {
            this.deletedRecords = new LinkedList<DynamicRecord>();
        }
        this.deletedRecords.add(record);
    }

    public void addPropertyBlock(PropertyBlock block) {
        this.ensureBlocksLoaded();
        assert (this.size() + block.getSize() <= PropertyType.getPayloadSize()) : "Exceeded capacity of property record " + this + ". My current size is reported as " + this.size() + "The added block was " + block + " (note that size is " + block.getSize() + ")";
        this.blockRecords[this.blockRecordsCursor++] = block;
    }

    private void ensureBlocksLoaded() {
        if (!this.blocksLoaded) {
            int length2;
            assert (this.blockRecordsCursor == 0);
            for (int index = 0; index < this.blocksCursor; index += length2) {
                PropertyType type = PropertyType.getPropertyTypeOrThrow(this.blocks[index]);
                PropertyBlock block = new PropertyBlock();
                length2 = type.calculateNumberOfBlocksUsed(this.blocks[index]);
                block.setValueBlocks(Arrays.copyOfRange(this.blocks, index, index + length2));
                this.blockRecords[this.blockRecordsCursor++] = block;
            }
            this.blocksLoaded = true;
        }
    }

    public void setPropertyBlock(PropertyBlock block) {
        this.removePropertyBlock(block.getKeyIndexId());
        this.addPropertyBlock(block);
    }

    public PropertyBlock getPropertyBlock(int keyIndex) {
        this.ensureBlocksLoaded();
        for (int i = 0; i < this.blockRecordsCursor; ++i) {
            PropertyBlock block = this.blockRecords[i];
            if (block.getKeyIndexId() != keyIndex) continue;
            return block;
        }
        return null;
    }

    public PropertyBlock removePropertyBlock(int keyIndex) {
        this.ensureBlocksLoaded();
        for (int i = 0; i < this.blockRecordsCursor; ++i) {
            if (this.blockRecords[i].getKeyIndexId() != keyIndex) continue;
            PropertyBlock block = this.blockRecords[i];
            if (--this.blockRecordsCursor > i) {
                this.blockRecords[i] = this.blockRecords[this.blockRecordsCursor];
            }
            return block;
        }
        return null;
    }

    public void clearPropertyBlocks() {
        this.blockRecordsCursor = 0;
    }

    public long getNextProp() {
        return this.nextProp;
    }

    public void setNextProp(long nextProp) {
        this.nextProp = nextProp;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Property[").append(this.getId()).append(",used=").append(this.inUse()).append(",prev=").append(this.prevProp).append(",next=").append(this.nextProp);
        if (this.entityId != -1L) {
            buf.append(this.entityType == 1 ? ",node=" : ",rel=").append(this.entityId);
        }
        if (this.blocksLoaded) {
            for (int i = 0; i < this.blockRecordsCursor; ++i) {
                buf.append(',').append(this.blockRecords[i]);
            }
        } else {
            buf.append(", (blocks not loaded)");
        }
        if (this.deletedRecords != null) {
            for (DynamicRecord dyn : this.deletedRecords) {
                buf.append(", del:").append(dyn);
            }
        }
        buf.append("]");
        return buf.toString();
    }

    public void setChanged(PrimitiveRecord primitive) {
        primitive.setIdTo(this);
    }

    public long getPrevProp() {
        return this.prevProp;
    }

    public void setPrevProp(long prev) {
        this.prevProp = prev;
    }

    @Override
    public PropertyRecord clone() {
        PropertyRecord result2 = (PropertyRecord)new PropertyRecord(this.getId()).initialize(this.inUse());
        result2.nextProp = this.nextProp;
        result2.prevProp = this.prevProp;
        result2.entityId = this.entityId;
        result2.entityType = this.entityType;
        System.arraycopy(this.blocks, 0, result2.blocks, 0, this.blocks.length);
        result2.blocksCursor = this.blocksCursor;
        for (int i = 0; i < this.blockRecordsCursor; ++i) {
            result2.blockRecords[i] = this.blockRecords[i].clone();
        }
        result2.blockRecordsCursor = this.blockRecordsCursor;
        result2.blocksLoaded = this.blocksLoaded;
        if (this.deletedRecords != null) {
            for (DynamicRecord deletedRecord : this.deletedRecords) {
                result2.addDeletedRecord(deletedRecord.clone());
            }
        }
        return result2;
    }

    public long[] getBlocks() {
        return this.blocks;
    }

    public void addLoadedBlock(long block) {
        assert (this.blocksCursor + 1 <= this.blocks.length) : "Capacity of " + this.blocks.length + " exceeded";
        this.blocks[this.blocksCursor++] = block;
    }

    public int getBlockCapacity() {
        return this.blocks.length;
    }

    public int getNumberOfBlocks() {
        return this.blocksCursor;
    }
}

