/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.storageengine.api.CommandVersion;

public class NeoStoreTransactionApplier
extends TransactionApplier.Adapter {
    private final CommandVersion version;
    private final LockGroup lockGroup;
    private final long transactionId;
    private final NeoStores neoStores;
    private final CacheAccessBackDoor cacheAccess;
    private final LockService lockService;

    public NeoStoreTransactionApplier(CommandVersion version, NeoStores neoStores, CacheAccessBackDoor cacheAccess, LockService lockService, long transactionId, LockGroup lockGroup) {
        this.version = version;
        this.lockGroup = lockGroup;
        this.transactionId = transactionId;
        this.lockService = lockService;
        this.neoStores = neoStores;
        this.cacheAccess = cacheAccess;
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) {
        this.lockGroup.add(this.lockService.acquireNodeLock(command.getKey(), LockService.LockType.WRITE_LOCK));
        this.updateStore(this.neoStores.getNodeStore(), command);
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) {
        this.lockGroup.add(this.lockService.acquireRelationshipLock(command.getKey(), LockService.LockType.WRITE_LOCK));
        this.updateStore(this.neoStores.getRelationshipStore(), command);
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) {
        if (command.getNodeId() != -1L) {
            this.lockGroup.add(this.lockService.acquireNodeLock(command.getNodeId(), LockService.LockType.WRITE_LOCK));
        } else if (command.getRelId() != -1L) {
            this.lockGroup.add(this.lockService.acquireRelationshipLock(command.getRelId(), LockService.LockType.WRITE_LOCK));
        }
        this.updateStore(this.neoStores.getPropertyStore(), command);
        return false;
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) {
        this.updateStore(this.neoStores.getRelationshipGroupStore(), command);
        return false;
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) {
        this.updateStore(this.neoStores.getRelationshipTypeTokenStore(), command);
        return false;
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) {
        this.updateStore(this.neoStores.getLabelTokenStore(), command);
        return false;
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) {
        this.updateStore(this.neoStores.getPropertyKeyTokenStore(), command);
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) {
        SchemaStore schemaStore = this.neoStores.getSchemaStore();
        if (this.version == CommandVersion.BEFORE) {
            boolean create2 = command.getMode() == Command.Mode.CREATE;
            for (DynamicRecord record : command.getRecordsBefore()) {
                if (create2) {
                    record.setInUse(false);
                }
                schemaStore.updateRecord(record);
            }
            return false;
        }
        for (DynamicRecord record : command.getRecordsAfter()) {
            schemaStore.updateRecord(record);
        }
        if (command.getSchemaRule() instanceof ConstraintRule) {
            switch (command.getMode()) {
                case UPDATE: 
                case CREATE: {
                    this.neoStores.getMetaDataStore().setLatestConstraintIntroducingTx(this.transactionId);
                    break;
                }
                case DELETE: {
                    break;
                }
                default: {
                    throw new IllegalStateException(command.getMode().name());
                }
            }
        }
        switch (command.getMode()) {
            case DELETE: {
                this.cacheAccess.removeSchemaRuleFromCache(command.getKey());
                break;
            }
            default: {
                this.cacheAccess.addSchemaRule(command.getSchemaRule());
            }
        }
        return false;
    }

    @Override
    public boolean visitNeoStoreCommand(Command.NeoStoreCommand command) {
        this.neoStores.getMetaDataStore().setGraphNextProp(this.selectRecordByCommandVersion(command).getNextProp());
        return false;
    }

    private <RECORD extends AbstractBaseRecord> void updateStore(RecordStore<RECORD> store, Command.BaseCommand<RECORD> command) {
        store.updateRecord(this.selectRecordByCommandVersion(command));
    }

    private <RECORD extends AbstractBaseRecord> RECORD selectRecordByCommandVersion(Command.BaseCommand<RECORD> command) {
        switch (this.version) {
            case BEFORE: {
                return command.getBefore();
            }
            case AFTER: {
                return command.getAfter();
            }
        }
        throw new IllegalArgumentException("Unexpected command version " + (Object)((Object)this.version));
    }
}

