/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;

public class PhysicalLogVersionedStoreChannel
implements LogVersionedStoreChannel {
    private final StoreChannel delegateChannel;
    private final long version;
    private final byte formatVersion;
    private long position;

    public PhysicalLogVersionedStoreChannel(StoreChannel delegateChannel, long version, byte formatVersion) throws IOException {
        this.delegateChannel = delegateChannel;
        this.version = version;
        this.formatVersion = formatVersion;
        this.position = delegateChannel.position();
    }

    @Override
    public FileLock tryLock() throws IOException {
        return this.delegateChannel.tryLock();
    }

    @Override
    public void writeAll(ByteBuffer src, long position2) {
        throw new UnsupportedOperationException("Not needed");
    }

    @Override
    public void writeAll(ByteBuffer src) throws IOException {
        this.advance(src.remaining());
        this.delegateChannel.writeAll(src);
    }

    @Override
    public int read(ByteBuffer dst, long position2) {
        throw new UnsupportedOperationException("Not needed");
    }

    @Override
    public void readAll(ByteBuffer dst) {
        throw new UnsupportedOperationException("Not needed");
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.delegateChannel.force(metaData);
    }

    @Override
    public StoreChannel position(long newPosition) throws IOException {
        this.position = newPosition;
        return this.delegateChannel.position(newPosition);
    }

    @Override
    public StoreChannel truncate(long size2) throws IOException {
        return this.delegateChannel.truncate(size2);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return (int)this.advance(this.delegateChannel.read(dst));
    }

    private long advance(long bytes2) {
        if (bytes2 != -1L) {
            this.position += bytes2;
        }
        return bytes2;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return (int)this.advance(this.delegateChannel.write(src));
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long size() throws IOException {
        return this.delegateChannel.size();
    }

    @Override
    public boolean isOpen() {
        return this.delegateChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegateChannel.close();
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length2) throws IOException {
        return this.advance(this.delegateChannel.write(srcs, offset, length2));
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.advance(this.delegateChannel.write(srcs));
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length2) throws IOException {
        return this.advance(this.delegateChannel.read(dsts, offset, length2));
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.advance(this.delegateChannel.read(dsts));
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public byte getLogFormatVersion() {
        return this.formatVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalLogVersionedStoreChannel that = (PhysicalLogVersionedStoreChannel)o;
        return this.version == that.version && this.delegateChannel.equals(that.delegateChannel);
    }

    public int hashCode() {
        int result2 = this.delegateChannel.hashCode();
        result2 = 31 * result2 + (int)(this.version ^ this.version >>> 32);
        return result2;
    }

    @Override
    public void flush() throws IOException {
        this.force(false);
    }
}

