/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.IncompleteLogHeaderException;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;

public class LogHeaderReader {
    private LogHeaderReader() {
    }

    public static LogHeader readLogHeader(FileSystemAbstraction fileSystem, File file) throws IOException {
        return LogHeaderReader.readLogHeader(fileSystem, file, true);
    }

    public static LogHeader readLogHeader(FileSystemAbstraction fileSystem, File file, boolean strict) throws IOException {
        try (StoreChannel channel = fileSystem.open(file, OpenMode.READ);){
            LogHeader logHeader = LogHeaderReader.readLogHeader(ByteBuffer.allocate(16), channel, strict, file);
            return logHeader;
        }
    }

    public static LogHeader readLogHeader(ByteBuffer buffer, ReadableByteChannel channel, boolean strict, File fileForAdditionalErrorInformationOrNull) throws IOException {
        buffer.clear();
        buffer.limit(16);
        int read = channel.read(buffer);
        if (read != 16) {
            if (strict) {
                if (fileForAdditionalErrorInformationOrNull != null) {
                    throw new IncompleteLogHeaderException(fileForAdditionalErrorInformationOrNull, read);
                }
                throw new IncompleteLogHeaderException(read);
            }
            return null;
        }
        buffer.flip();
        long encodedLogVersions = buffer.getLong();
        byte logFormatVersion = LogHeaderReader.decodeLogFormatVersion(encodedLogVersions);
        long logVersion = LogHeaderReader.decodeLogVersion(encodedLogVersions);
        long previousCommittedTx = buffer.getLong();
        return new LogHeader(logFormatVersion, logVersion, previousCommittedTx);
    }

    static long decodeLogVersion(long encLogVersion) {
        return encLogVersion & 0xFFFFFFFFFFFFFFL;
    }

    static byte decodeLogFormatVersion(long encLogVersion) {
        return (byte)(encLogVersion >> 56 & 0xFFL);
    }
}

