/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PositionAwarePhysicalFlushableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

class TransactionLogFile
extends LifecycleAdapter
implements LogFile {
    private final AtomicLong rotateAtSize;
    private final TransactionLogFiles logFiles;
    private final TransactionLogFilesContext context;
    private final LogVersionBridge readerLogVersionBridge;
    private PositionAwarePhysicalFlushableChannel writer;
    private LogVersionRepository logVersionRepository;
    private volatile PhysicalLogVersionedStoreChannel channel;

    TransactionLogFile(TransactionLogFiles logFiles, TransactionLogFilesContext context) {
        this.rotateAtSize = context.getRotationThreshold();
        this.context = context;
        this.logFiles = logFiles;
        this.readerLogVersionBridge = new ReaderLogVersionBridge(logFiles);
    }

    @Override
    public void init() throws IOException {
        this.logVersionRepository = this.context.getLogVersionRepository();
        long lastLogVersionUsed = this.logVersionRepository.getCurrentLogVersion();
        this.channel = this.logFiles.createLogChannelForVersion(lastLogVersionUsed, OpenMode.READ_WRITE, this.context::getLastCommittedTransactionId);
        this.channel.close();
    }

    @Override
    public void start() throws IOException {
        long lastLogVersionUsed = this.logVersionRepository.getCurrentLogVersion();
        this.channel = this.logFiles.createLogChannelForVersion(lastLogVersionUsed, OpenMode.READ_WRITE, this.context::getLastCommittedTransactionId);
        this.channel.position(this.channel.size());
        this.writer = new PositionAwarePhysicalFlushableChannel(this.channel);
    }

    @Override
    public void shutdown() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.channel != null) {
            this.channel.close();
        }
    }

    @Override
    public boolean rotationNeeded() {
        return this.channel.position() >= this.rotateAtSize.get();
    }

    @Override
    public synchronized void rotate() throws IOException {
        this.channel = this.rotate(this.channel);
        this.writer.setChannel(this.channel);
    }

    private PhysicalLogVersionedStoreChannel rotate(LogVersionedStoreChannel currentLog) throws IOException {
        long newLogVersion = this.logVersionRepository.incrementAndGetVersion();
        this.writer.prepareForFlush().flush();
        PhysicalLogVersionedStoreChannel newLog = this.logFiles.createLogChannelForVersion(newLogVersion, OpenMode.READ_WRITE, this.context::committingTransactionId);
        currentLog.close();
        return newLog;
    }

    @Override
    public FlushablePositionAwareChannel getWriter() {
        return this.writer;
    }

    @Override
    public ReadableLogChannel getReader(LogPosition position2) throws IOException {
        return this.getReader(position2, this.readerLogVersionBridge);
    }

    @Override
    public ReadableLogChannel getReader(LogPosition position2, LogVersionBridge logVersionBridge) throws IOException {
        PhysicalLogVersionedStoreChannel logChannel = this.logFiles.openForVersion(position2.getLogVersion());
        logChannel.position(position2.getByteOffset());
        return new ReadAheadLogChannel(logChannel, logVersionBridge);
    }

    @Override
    public void accept(LogFile.LogFileVisitor visitor, LogPosition startingFromPosition) throws IOException {
        try (ReadableLogChannel reader = this.getReader(startingFromPosition);){
            visitor.visit(reader);
        }
    }
}

