/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;

public class TransactionLogFileInformation
implements LogFileInformation {
    private final LogFiles logFiles;
    private final LogHeaderCache logHeaderCache;
    private final TransactionLogFileTimestampMapper logFileTimestampMapper;
    private final TransactionLogFilesContext logFileContext;

    TransactionLogFileInformation(LogFiles logFiles, LogHeaderCache logHeaderCache, TransactionLogFilesContext context) {
        this.logFiles = logFiles;
        this.logHeaderCache = logHeaderCache;
        this.logFileContext = context;
        this.logFileTimestampMapper = new TransactionLogFileTimestampMapper(logFiles, context.getLogEntryReader());
    }

    @Override
    public long getFirstExistingEntryId() throws IOException {
        long version = this.logFiles.getHighestLogVersion();
        long candidateFirstTx = -1L;
        while (this.logFiles.versionExists(version)) {
            candidateFirstTx = this.getFirstEntryId(version);
            --version;
        }
        return this.logFiles.hasAnyEntries(++version) ? candidateFirstTx : -1L;
    }

    @Override
    public long getFirstEntryId(long version) throws IOException {
        Long logHeader = this.logHeaderCache.getLogHeader(version);
        if (logHeader != null) {
            return logHeader + 1L;
        }
        if (this.logFiles.versionExists(version)) {
            long previousVersionLastCommittedTx = this.logFiles.extractHeader((long)version).lastCommittedTxId;
            this.logHeaderCache.putHeader(version, previousVersionLastCommittedTx);
            return previousVersionLastCommittedTx + 1L;
        }
        return -1L;
    }

    @Override
    public long getLastEntryId() {
        return this.logFileContext.getLastCommittedTransactionId();
    }

    @Override
    public long getFirstStartRecordTimestamp(long version) throws IOException {
        return this.logFileTimestampMapper.getTimestampForVersion(version);
    }

    private static class TransactionLogFileTimestampMapper {
        private final LogFiles logFiles;
        private final LogEntryReader<ReadableLogChannel> logEntryReader;

        TransactionLogFileTimestampMapper(LogFiles logFiles, LogEntryReader<ReadableLogChannel> logEntryReader) {
            this.logFiles = logFiles;
            this.logEntryReader = logEntryReader;
        }

        long getTimestampForVersion(long version) throws IOException {
            LogPosition position2 = LogPosition.start(version);
            try (ReadableLogChannel channel = this.logFiles.getLogFile().getReader(position2);){
                LogEntry entry;
                while ((entry = this.logEntryReader.readLogEntry(channel)) != null) {
                    if (!(entry instanceof LogEntryStart)) continue;
                    long l = ((LogEntryStart)entry.as()).getTimeWritten();
                    return l;
                }
            }
            return -1L;
        }
    }
}

