/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.ExplicitIndexProvider;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.util.MultiResource;
import org.neo4j.kernel.spi.explicitindex.IndexImplementation;
import org.neo4j.storageengine.api.StoreFileMetadata;

public class NeoStoreFileIndexListing {
    private final LabelScanStore labelScanStore;
    private final IndexingService indexingService;
    private final ExplicitIndexProvider explicitIndexProviders;
    private static final Function<File, StoreFileMetadata> toStoreFileMetatadata = file -> new StoreFileMetadata((File)file, 1);

    NeoStoreFileIndexListing(LabelScanStore labelScanStore, IndexingService indexingService, ExplicitIndexProvider explicitIndexProviders) {
        this.labelScanStore = labelScanStore;
        this.indexingService = indexingService;
        this.explicitIndexProviders = explicitIndexProviders;
    }

    public LongSet getIndexIds() {
        return this.indexingService.getIndexIds();
    }

    Resource gatherSchemaIndexFiles(Collection<StoreFileMetadata> targetFiles) throws IOException {
        ResourceIterator<File> snapshot = this.indexingService.snapshotIndexFiles();
        this.getSnapshotFilesMetadata(snapshot, targetFiles);
        return snapshot;
    }

    Resource gatherLabelScanStoreFiles(Collection<StoreFileMetadata> targetFiles) {
        ResourceIterator<File> snapshot = this.labelScanStore.snapshotStoreFiles();
        this.getSnapshotFilesMetadata(snapshot, targetFiles);
        return snapshot;
    }

    Resource gatherExplicitIndexFiles(Collection<StoreFileMetadata> files2) throws IOException {
        ArrayList<ResourceIterator<File>> snapshots = new ArrayList<ResourceIterator<File>>();
        for (IndexImplementation indexProvider : this.explicitIndexProviders.allIndexProviders()) {
            ResourceIterator<File> snapshot = indexProvider.listStoreFiles();
            snapshots.add(snapshot);
            this.getSnapshotFilesMetadata(snapshot, files2);
        }
        return new MultiResource(snapshots);
    }

    private void getSnapshotFilesMetadata(ResourceIterator<File> snapshot, Collection<StoreFileMetadata> targetFiles) {
        snapshot.stream().map(toStoreFileMetatadata).forEach(targetFiles::add);
    }

    public ResourceIterator<StoreFileMetadata> getSnapshot(long indexId) throws IOException {
        try {
            ResourceIterator<File> snapshot = this.indexingService.getIndexProxy(indexId).snapshotFiles();
            ArrayList<StoreFileMetadata> files2 = new ArrayList<StoreFileMetadata>();
            this.getSnapshotFilesMetadata(snapshot, files2);
            return Iterators.resourceIterator(files2.iterator(), snapshot);
        }
        catch (IndexNotFoundKernelException e) {
            return Iterators.emptyResourceIterator();
        }
    }
}

