/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import java.util.function.LongFunction;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityIdIterator;
import org.neo4j.storageengine.api.StorageEntityScanCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.values.storable.Value;

public abstract class PropertyAwareEntityStoreScan<CURSOR extends StorageEntityScanCursor, FAILURE extends Exception>
implements StoreScan<FAILURE> {
    final CURSOR entityCursor;
    private final StoragePropertyCursor propertyCursor;
    private final StorageReader storageReader;
    private volatile boolean continueScanning;
    private long count;
    private long totalCount;
    private final IntPredicate propertyKeyIdFilter;
    private final LongFunction<Lock> lockFunction;
    private PhaseTracker phaseTracker;

    protected PropertyAwareEntityStoreScan(StorageReader storageReader, long totalEntityCount, IntPredicate propertyKeyIdFilter, LongFunction<Lock> lockFunction) {
        this.storageReader = storageReader;
        this.entityCursor = this.allocateCursor(storageReader);
        this.propertyCursor = storageReader.allocatePropertyCursor();
        this.propertyKeyIdFilter = propertyKeyIdFilter;
        this.lockFunction = lockFunction;
        this.totalCount = totalEntityCount;
        this.phaseTracker = PhaseTracker.nullInstance;
    }

    protected abstract CURSOR allocateCursor(StorageReader var1);

    static boolean containsAnyEntityToken(int[] entityTokenFilter, long ... entityTokens) {
        for (long candidate : entityTokens) {
            if (!ArrayUtils.contains(entityTokenFilter, Math.toIntExact(candidate))) continue;
            return true;
        }
        return false;
    }

    boolean hasRelevantProperty(CURSOR cursor, EntityUpdates.Builder updates) {
        if (!cursor.hasProperties()) {
            return false;
        }
        boolean hasRelevantProperty = false;
        this.propertyCursor.init(cursor.propertiesReference());
        while (this.propertyCursor.next()) {
            int propertyKeyId = this.propertyCursor.propertyKey();
            if (!this.propertyKeyIdFilter.test(propertyKeyId)) continue;
            Value value2 = this.propertyCursor.propertyValue();
            updates.added(propertyKeyId, value2);
            hasRelevantProperty = true;
        }
        return hasRelevantProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws FAILURE {
        this.entityCursor.scan();
        try (EntityIdIterator entityIdIterator = this.getEntityIdIterator();){
            this.continueScanning = true;
            while (this.continueScanning && entityIdIterator.hasNext()) {
                this.phaseTracker.enterPhase(PhaseTracker.Phase.SCAN);
                long id2 = entityIdIterator.next();
                Lock ignored = this.lockFunction.apply(id2);
                Throwable throwable = null;
                try {
                    ++this.count;
                    if (!this.process(this.entityCursor)) continue;
                    entityIdIterator.invalidateCache();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.propertyCursor, this.entityCursor, this.storageReader});
            throw throwable;
        }
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.propertyCursor, this.entityCursor, this.storageReader});
    }

    @Override
    public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, IndexEntryUpdate<?> update2, long currentlyIndexedNodeId) {
        if (update2.getEntityId() <= currentlyIndexedNodeId) {
            updater.process(update2);
        }
    }

    protected abstract boolean process(CURSOR var1) throws FAILURE;

    @Override
    public void stop() {
        this.continueScanning = false;
    }

    @Override
    public PopulationProgress getProgress() {
        if (this.totalCount > 0L) {
            return PopulationProgress.single(this.count, this.totalCount);
        }
        return PopulationProgress.DONE;
    }

    @Override
    public void setPhaseTracker(PhaseTracker phaseTracker) {
        this.phaseTracker = phaseTracker;
    }

    protected EntityIdIterator getEntityIdIterator() {
        return new EntityIdIterator(){
            private boolean hasSeenNext;
            private boolean hasNext;

            @Override
            public void invalidateCache() {
            }

            @Override
            public long next() {
                if (!this.hasNext()) {
                    throw new IllegalStateException();
                }
                this.hasSeenNext = false;
                this.hasNext = false;
                return PropertyAwareEntityStoreScan.this.entityCursor.entityReference();
            }

            @Override
            public boolean hasNext() {
                if (!this.hasSeenNext) {
                    this.hasNext = PropertyAwareEntityStoreScan.this.entityCursor.next();
                    this.hasSeenNext = true;
                }
                return this.hasNext;
            }

            @Override
            public void close() {
            }
        };
    }
}

