/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.graphdb.traversal.PathEvaluator;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.graphdb.traversal.UniquenessFilter;
import org.neo4j.kernel.impl.traversal.AbstractTraverserIterator;
import org.neo4j.kernel.impl.traversal.AsOneStartBranch;

class MonoDirectionalTraverserIterator
extends AbstractTraverserIterator {
    private final BranchSelector selector;
    private final PathEvaluator evaluator;
    private final UniquenessFilter uniqueness;

    MonoDirectionalTraverserIterator(Resource resource, UniquenessFilter uniqueness, PathExpander expander, BranchOrderingPolicy order, PathEvaluator evaluator, Iterable<Node> startNodes, InitialBranchState initialState, UniquenessFactory uniquenessFactory) {
        super(resource);
        this.uniqueness = uniqueness;
        this.evaluator = evaluator;
        this.selector = order.create(new AsOneStartBranch(this, startNodes, initialState, uniquenessFactory), expander);
    }

    public Evaluation evaluate(TraversalBranch branch, BranchState state) {
        return this.evaluator.evaluate(branch, state);
    }

    @Override
    protected Path fetchNextOrNull() {
        TraversalBranch result2;
        do {
            if ((result2 = this.selector.next(this)) != null) continue;
            this.close();
            return null;
        } while (!result2.includes());
        ++this.numberOfPathsReturned;
        return result2;
    }

    @Override
    public boolean isUniqueFirst(TraversalBranch branch) {
        return this.uniqueness.checkFirst(branch);
    }

    @Override
    public boolean isUnique(TraversalBranch branch) {
        return this.uniqueness.check(branch);
    }
}

