/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.concurrent.TimeoutException;
import org.neo4j.kernel.impl.util.OutOfOrderSequence;
import org.neo4j.kernel.impl.util.SequenceArray;

public class ArrayQueueOutOfOrderSequence
implements OutOfOrderSequence {
    private volatile int version;
    private volatile long highestGapFreeNumber;
    private long[] highestGapFreeMeta;
    private final SequenceArray outOfOrderQueue;
    private long[] metaArray;
    private volatile long highestEverSeen;

    public ArrayQueueOutOfOrderSequence(long startingNumber, int initialArraySize, long[] initialMeta) {
        this.highestGapFreeNumber = startingNumber;
        this.highestEverSeen = startingNumber;
        this.metaArray = initialMeta;
        this.highestGapFreeMeta = initialMeta;
        this.outOfOrderQueue = new SequenceArray(initialMeta.length + 1, initialArraySize);
    }

    @Override
    public synchronized boolean offer(long number, long[] meta) {
        this.highestEverSeen = Math.max(this.highestEverSeen, number);
        if (this.highestGapFreeNumber + 1L == number) {
            ++this.version;
            this.highestGapFreeNumber = this.outOfOrderQueue.pollHighestGapFree(number, this.metaArray);
            this.highestGapFreeMeta = this.highestGapFreeNumber == number ? meta : this.metaArray;
            ++this.version;
            this.notifyAll();
            return true;
        }
        this.outOfOrderQueue.offer(this.highestGapFreeNumber, number, this.pack(meta));
        return false;
    }

    @Override
    public long highestEverSeen() {
        return this.highestEverSeen;
    }

    private long[] pack(long[] meta) {
        this.metaArray = meta;
        return this.metaArray;
    }

    @Override
    public long[] get() {
        long[] meta;
        long number;
        while (true) {
            int versionBefore;
            if (((versionBefore = this.version) & 1) == 1) {
                continue;
            }
            number = this.highestGapFreeNumber;
            meta = this.highestGapFreeMeta;
            if (this.version == versionBefore) break;
        }
        return this.createResult(number, meta);
    }

    @Override
    public synchronized void await(long awaitedNumber, long timeoutMillis) throws TimeoutException, InterruptedException {
        long endTime = System.currentTimeMillis() + timeoutMillis;
        while (awaitedNumber > this.highestGapFreeNumber) {
            long timeLeft = endTime - System.currentTimeMillis();
            if (timeLeft > 0L) {
                this.wait(timeLeft);
                continue;
            }
            throw new TimeoutException("Awaited number was not reached");
        }
    }

    private long[] createResult(long number, long[] meta) {
        long[] result2 = new long[meta.length + 1];
        result2[0] = number;
        System.arraycopy(meta, 0, result2, 1, meta.length);
        return result2;
    }

    @Override
    public long getHighestGapFreeNumber() {
        return this.highestGapFreeNumber;
    }

    @Override
    public synchronized boolean seen(long number, long[] meta) {
        if (number < this.highestGapFreeNumber) {
            return true;
        }
        if (number == this.highestGapFreeNumber) {
            return this.highestGapFreeMeta == meta;
        }
        return this.outOfOrderQueue.seen(this.highestGapFreeNumber, number, meta);
    }

    @Override
    public synchronized void set(long number, long[] meta) {
        this.highestEverSeen = number;
        this.highestGapFreeNumber = number;
        this.highestGapFreeMeta = meta;
        this.outOfOrderQueue.clear();
    }

    public synchronized String toString() {
        return String.format("out-of-order-sequence:%d %d [%s]", this.highestEverSeen, this.highestGapFreeNumber, this.outOfOrderQueue);
    }
}

