/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.lang.reflect.Array;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.graphdb.traversal.Paths;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.ReverseArrayIterator;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;

public abstract class BaseToObjectValueWriter<E extends Exception>
implements AnyValueWriter<E> {
    private final Deque<Writer> stack = new ArrayDeque<Writer>();

    public BaseToObjectValueWriter() {
        this.stack.push(new ObjectWriter());
    }

    protected abstract Node newNodeProxyById(long var1);

    protected abstract Relationship newRelationshipProxyById(long var1);

    protected abstract Point newPoint(CoordinateReferenceSystem var1, double[] var2);

    public Object value() {
        assert (this.stack.size() == 1);
        return this.stack.getLast().value();
    }

    private void writeValue(Object value2) {
        assert (!this.stack.isEmpty());
        Writer head2 = this.stack.peek();
        head2.write(value2);
    }

    @Override
    public void writeNodeReference(long nodeId) throws RuntimeException {
        throw new UnsupportedOperationException("Cannot write a raw node reference");
    }

    @Override
    public void writeNode(long nodeId, TextArray ignore, MapValue properties) throws RuntimeException {
        if (nodeId >= 0L) {
            this.writeValue(this.newNodeProxyById(nodeId));
        }
    }

    @Override
    public void writeVirtualNodeHack(Object node) {
        this.writeValue(node);
    }

    @Override
    public void writeRelationshipReference(long relId) throws RuntimeException {
        throw new UnsupportedOperationException("Cannot write a raw edge reference");
    }

    @Override
    public void writeRelationship(long relId, long startNodeId, long endNodeId, TextValue type, MapValue properties) throws RuntimeException {
        if (relId >= 0L) {
            this.writeValue(this.newRelationshipProxyById(relId));
        }
    }

    @Override
    public void writeVirtualRelationshipHack(Object relationship) {
        this.writeValue(relationship);
    }

    @Override
    public void beginMap(int size2) throws RuntimeException {
        this.stack.push(new MapWriter(size2));
    }

    @Override
    public void endMap() throws RuntimeException {
        assert (!this.stack.isEmpty());
        this.writeValue(this.stack.pop().value());
    }

    @Override
    public void beginList(int size2) throws RuntimeException {
        this.stack.push(new ListWriter(size2));
    }

    @Override
    public void endList() throws RuntimeException {
        assert (!this.stack.isEmpty());
        this.writeValue(this.stack.pop().value());
    }

    @Override
    public void writePath(NodeValue[] nodes, RelationshipValue[] relationships) throws RuntimeException {
        assert (nodes != null);
        assert (nodes.length > 0);
        assert (relationships != null);
        assert (nodes.length == relationships.length + 1);
        final Node[] nodeProxies = new Node[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodeProxies[i] = this.newNodeProxyById(nodes[i].id());
        }
        final Relationship[] relationship = new Relationship[relationships.length];
        for (int i = 0; i < relationships.length; ++i) {
            relationship[i] = this.newRelationshipProxyById(relationships[i].id());
        }
        this.writeValue(new Path(){

            @Override
            public Node startNode() {
                return nodeProxies[0];
            }

            @Override
            public Node endNode() {
                return nodeProxies[nodeProxies.length - 1];
            }

            @Override
            public Relationship lastRelationship() {
                return relationship[relationship.length - 1];
            }

            @Override
            public Iterable<Relationship> relationships() {
                return Arrays.asList(relationship);
            }

            @Override
            public Iterable<Relationship> reverseRelationships() {
                return () -> new ReverseArrayIterator<Relationship>(relationship);
            }

            @Override
            public Iterable<Node> nodes() {
                return Arrays.asList(nodeProxies);
            }

            @Override
            public Iterable<Node> reverseNodes() {
                return () -> new ReverseArrayIterator<Node>(nodeProxies);
            }

            @Override
            public int length() {
                return relationship.length;
            }

            public int hashCode() {
                if (relationship.length == 0) {
                    return this.startNode().hashCode();
                }
                return Arrays.hashCode(relationship);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof Path) {
                    Path other2 = (Path)obj;
                    return this.startNode().equals(other2.startNode()) && Iterators.iteratorsEqual(this.relationships().iterator(), other2.relationships().iterator());
                }
                return false;
            }

            @Override
            public Iterator<PropertyContainer> iterator() {
                return new Iterator<PropertyContainer>(){
                    Iterator<? extends PropertyContainer> current;
                    Iterator<? extends PropertyContainer> next;
                    {
                        this.current = this.nodes().iterator();
                        this.next = this.relationships().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current.hasNext();
                    }

                    @Override
                    public PropertyContainer next() {
                        try {
                            PropertyContainer propertyContainer = this.current.next();
                            return propertyContainer;
                        }
                        finally {
                            Iterator<? extends PropertyContainer> temp = this.current;
                            this.current = this.next;
                            this.next = temp;
                        }
                    }

                    @Override
                    public void remove() {
                        this.next.remove();
                    }
                };
            }

            @Override
            public String toString() {
                return Paths.defaultPathToStringWithNotInTransactionFallback(this);
            }
        });
    }

    @Override
    public final void writePoint(CoordinateReferenceSystem crs, double[] coordinate) {
        this.writeValue(this.newPoint(crs, coordinate));
    }

    @Override
    public void writeNull() throws RuntimeException {
        this.writeValue(null);
    }

    @Override
    public void writeBoolean(boolean value2) throws RuntimeException {
        this.writeValue(value2);
    }

    @Override
    public void writeInteger(byte value2) throws RuntimeException {
        this.writeValue(value2);
    }

    @Override
    public void writeInteger(short value2) throws RuntimeException {
        this.writeValue(value2);
    }

    @Override
    public void writeInteger(int value2) throws RuntimeException {
        this.writeValue(value2);
    }

    @Override
    public void writeInteger(long value2) throws RuntimeException {
        this.writeValue(value2);
    }

    @Override
    public void writeFloatingPoint(float value2) throws RuntimeException {
        this.writeValue(Float.valueOf(value2));
    }

    @Override
    public void writeFloatingPoint(double value2) throws RuntimeException {
        this.writeValue(value2);
    }

    @Override
    public void writeString(String value2) throws RuntimeException {
        this.writeValue(value2);
    }

    @Override
    public void writeString(char value2) throws RuntimeException {
        this.writeValue(Character.valueOf(value2));
    }

    @Override
    public void beginArray(int size2, ValueWriter.ArrayType arrayType) throws RuntimeException {
        this.stack.push(new ArrayWriter(size2, arrayType));
    }

    @Override
    public void endArray() throws RuntimeException {
        assert (!this.stack.isEmpty());
        this.writeValue(this.stack.pop().value());
    }

    @Override
    public void writeByteArray(byte[] value2) throws RuntimeException {
        this.writeValue(value2);
    }

    @Override
    public void writeDuration(long months, long days, long seconds, int nanos) {
        this.writeValue(DurationValue.duration(months, days, seconds, nanos));
    }

    @Override
    public void writeDate(LocalDate localDate) throws RuntimeException {
        this.writeValue(localDate);
    }

    @Override
    public void writeLocalTime(LocalTime localTime) throws RuntimeException {
        this.writeValue(localTime);
    }

    @Override
    public void writeTime(OffsetTime offsetTime) throws RuntimeException {
        this.writeValue(offsetTime);
    }

    @Override
    public void writeLocalDateTime(LocalDateTime localDateTime) throws RuntimeException {
        this.writeValue(localDateTime);
    }

    @Override
    public void writeDateTime(ZonedDateTime zonedDateTime) throws RuntimeException {
        this.writeValue(zonedDateTime);
    }

    private static class ListWriter
    implements Writer {
        private final List<Object> list;

        ListWriter(int size2) {
            this.list = new ArrayList<Object>(size2);
        }

        @Override
        public void write(Object value2) {
            this.list.add(value2);
        }

        @Override
        public Object value() {
            return this.list;
        }
    }

    private static class ArrayWriter
    implements Writer {
        protected final Object array;
        private int index;

        ArrayWriter(int size2, ValueWriter.ArrayType arrayType) {
            switch (arrayType) {
                case SHORT: {
                    this.array = Array.newInstance(Short.TYPE, size2);
                    break;
                }
                case INT: {
                    this.array = Array.newInstance(Integer.TYPE, size2);
                    break;
                }
                case BYTE: {
                    this.array = Array.newInstance(Byte.TYPE, size2);
                    break;
                }
                case LONG: {
                    this.array = Array.newInstance(Long.TYPE, size2);
                    break;
                }
                case FLOAT: {
                    this.array = Array.newInstance(Float.TYPE, size2);
                    break;
                }
                case DOUBLE: {
                    this.array = Array.newInstance(Double.TYPE, size2);
                    break;
                }
                case BOOLEAN: {
                    this.array = Array.newInstance(Boolean.TYPE, size2);
                    break;
                }
                case STRING: {
                    this.array = Array.newInstance(String.class, size2);
                    break;
                }
                case CHAR: {
                    this.array = Array.newInstance(Character.TYPE, size2);
                    break;
                }
                default: {
                    this.array = new Object[size2];
                }
            }
        }

        @Override
        public void write(Object value2) {
            Array.set(this.array, this.index++, value2);
        }

        @Override
        public Object value() {
            return this.array;
        }
    }

    private static class MapWriter
    implements Writer {
        private String key;
        private boolean isKey = true;
        private final HashMap<String, Object> map;

        MapWriter(int size2) {
            this.map = new HashMap(size2);
        }

        @Override
        public void write(Object value2) {
            if (this.isKey) {
                this.key = (String)value2;
                this.isKey = false;
            } else {
                this.map.put(this.key, value2);
                this.isKey = true;
            }
        }

        @Override
        public Object value() {
            return this.map;
        }
    }

    private static class ObjectWriter
    implements Writer {
        private Object value;

        private ObjectWriter() {
        }

        @Override
        public void write(Object value2) {
            this.value = value2;
        }

        @Override
        public Object value() {
            return this.value;
        }
    }

    private static interface Writer {
        public void write(Object var1);

        public Object value();
    }
}

