/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.impl.util.TraceLog;

public class DebugUtil {
    private DebugUtil() {
    }

    public static void logTrace(String fmt, Object ... args) {
        DebugUtil.logTrace(2, 5, fmt, args);
    }

    public static void logTrace(int skip, int limit, String fmt, Object ... args) {
        if (DebugUtil.enabledAssertions()) {
            Thread thread = Thread.currentThread();
            String threadName = thread.getName();
            ThreadGroup group = thread.getThreadGroup();
            String groupPart = group != null ? " in group " + group.getName() : "";
            String message = "[" + threadName + groupPart + "] " + String.format(fmt, args);
            TraceLog traceLog = new TraceLog(message);
            DebugUtil.printLimitedStackTrace(System.err, traceLog, skip, limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printLimitedStackTrace(PrintStream out, Throwable cause, int skip, int limit) {
        PrintStream printStream = out;
        synchronized (printStream) {
            String[] lines2;
            for (String line : lines2 = Exceptions.stringify(cause).split(System.lineSeparator())) {
                if (line.startsWith("\tat ")) {
                    if (skip > 0) {
                        --skip;
                        continue;
                    }
                    if (limit <= 0) break;
                    --limit;
                    out.println(line);
                    continue;
                }
                out.println(line);
            }
        }
    }

    public static void printShortStackTrace(Throwable cause, int maxNumberOfStackLines) {
        System.out.println(DebugUtil.firstLinesOf(Exceptions.stringify(cause), maxNumberOfStackLines + 1));
    }

    public static String firstLinesOf(String string2, int maxNumberOfLines) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        try {
            BufferedReader reader = new BufferedReader(new StringReader(string2));
            String line = null;
            for (int count2 = 0; (line = reader.readLine()) != null && count2 < maxNumberOfLines; ++count2) {
                writer.println(line);
            }
            writer.close();
            return stringWriter.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't happen", e);
        }
    }

    public static boolean stackTraceContains(Thread thread, Predicate<StackTraceElement> predicate) {
        for (StackTraceElement element : thread.getStackTrace()) {
            if (!predicate.test(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean currentStackTraceContains(Predicate<StackTraceElement> predicate) {
        return DebugUtil.stackTraceContains(Thread.currentThread(), predicate);
    }

    public static Predicate<StackTraceElement> classNameIs(String className) {
        return item -> item.getClassName().equals(className);
    }

    public static Predicate<StackTraceElement> classNameContains(String classNamePart) {
        return item -> item.getClassName().contains(classNamePart);
    }

    public static Predicate<StackTraceElement> classIs(Class<?> cls) {
        return item -> item.getClassName().equals(cls.getName());
    }

    public static Predicate<StackTraceElement> classNameAndMethodAre(String className, String methodName) {
        return item -> item.getClassName().equals(className) && item.getMethodName().equals(methodName);
    }

    public static Predicate<StackTraceElement> classAndMethodAre(Class<?> cls, String methodName) {
        return item -> item.getClassName().equals(cls.getName()) && item.getMethodName().equals(methodName);
    }

    public static Predicate<StackTraceElement> methodIs(String methodName) {
        return item -> item.getMethodName().equals(methodName);
    }

    private static boolean enabledAssertions() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError((Object)"A trick to set this variable to true if assertions are enabled");
            }
        }
        return enabled;
    }

    public static long time(long startTime, String message) {
        System.out.println(Format.duration(System.currentTimeMillis() - startTime) + ": " + message);
        return System.currentTimeMillis();
    }

    public static abstract class Timer {
        private final TimeUnit unit;
        private long startTime;

        protected Timer(TimeUnit unit) {
            this.unit = unit;
            this.startTime = this.currentTime();
        }

        protected abstract long currentTime();

        public void reset() {
            this.startTime = this.currentTime();
        }

        public void at(String point) {
            long duration = this.currentTime() - this.startTime;
            System.out.println(Format.duration(this.unit.toMillis(duration)) + " @ " + point);
            this.startTime = this.currentTime();
        }

        public static Timer millis() {
            return new Millis();
        }

        public static Timer nanos() {
            return new Nanos();
        }

        private static class Nanos
        extends Timer {
            Nanos() {
                super(TimeUnit.NANOSECONDS);
            }

            @Override
            protected long currentTime() {
                return System.nanoTime();
            }
        }

        private static class Millis
        extends Timer {
            Millis() {
                super(TimeUnit.MILLISECONDS);
            }

            @Override
            protected long currentTime() {
                return System.currentTimeMillis();
            }
        }
    }

    public static class CallStack {
        private final String message;
        private final Throwable stackTrace;
        private final StackTraceElement[] elements;
        private final boolean considerMessage;

        public CallStack(Throwable stackTrace, boolean considerMessage) {
            this.message = stackTrace.getMessage();
            this.stackTrace = stackTrace;
            this.considerMessage = considerMessage;
            this.elements = stackTrace.getStackTrace();
        }

        public CallStack(StackTraceElement[] elements, String message) {
            this.message = message;
            this.stackTrace = null;
            this.elements = elements;
            this.considerMessage = true;
        }

        public int hashCode() {
            int hashCode2 = this.message == null || !this.considerMessage ? 31 : this.message.hashCode();
            for (StackTraceElement element : this.elements) {
                hashCode2 = hashCode2 * 9 + element.hashCode();
            }
            return hashCode2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CallStack)) {
                return false;
            }
            CallStack o = (CallStack)obj;
            if (this.considerMessage && (this.message == null ? o.message != null : !this.message.equals(o.message))) {
                return false;
            }
            if (this.elements.length != o.elements.length) {
                return false;
            }
            for (int i = 0; i < this.elements.length; ++i) {
                if (this.elements[i].equals(o.elements[i])) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.stackTrace != null ? this.stackTrace.getClass().getName() + ": " : "").append(this.message != null ? this.message : "");
            for (StackTraceElement element : this.elements) {
                builder.append(String.format("%n", new Object[0])).append("    at ").append(element.toString());
            }
            return builder.toString();
        }
    }

    public static class StackTracer {
        private final Map<CallStack, AtomicInteger> uniqueStackTraces = new HashMap<CallStack, AtomicInteger>();
        private boolean considerMessages = true;

        public AtomicInteger add(Throwable t) {
            CallStack key = new CallStack(t, this.considerMessages);
            AtomicInteger count2 = this.uniqueStackTraces.computeIfAbsent(key, k -> new AtomicInteger());
            count2.incrementAndGet();
            return count2;
        }

        public void print(PrintStream out, int interestThreshold) {
            System.out.println("Printing stack trace counts:");
            long total2 = 0L;
            for (Map.Entry<CallStack, AtomicInteger> entry : this.uniqueStackTraces.entrySet()) {
                if (entry.getValue().get() >= interestThreshold) {
                    out.println(entry.getValue() + " times:");
                    entry.getKey().stackTrace.printStackTrace(out);
                }
                total2 += (long)entry.getValue().get();
            }
            out.println("------");
            out.println("Total:" + total2);
        }

        public StackTracer printAtShutdown(PrintStream out, int interestThreshold) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.print(out, interestThreshold)));
            return this;
        }

        public StackTracer ignoreMessages() {
            this.considerMessages = false;
            return this;
        }
    }
}

