/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.impl.factory.Multimaps;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.util.DependencySatisfier;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;

public class Dependencies
extends DependencyResolver.Adapter
implements DependencySatisfier {
    private final DependencyResolver parent;
    private final MutableListMultimap<Class, Object> typeDependencies;

    public Dependencies() {
        this.typeDependencies = Multimaps.mutable.list.empty();
        this.parent = null;
    }

    public Dependencies(DependencyResolver parent2) {
        this.typeDependencies = Multimaps.mutable.list.empty();
        Objects.requireNonNull(parent2);
        this.parent = parent2;
    }

    @Override
    public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
        ListIterable options = this.typeDependencies.get((Object)type);
        if (options.notEmpty()) {
            return selector.select(type, options);
        }
        if (this.parent != null) {
            return this.parent.resolveDependency(type, selector);
        }
        throw new UnsatisfiedDependencyException(type);
    }

    @Override
    public <T> Iterable<? extends T> resolveTypeDependencies(Class<T> type) {
        ListIterable options = this.typeDependencies.get((Object)type);
        if (this.parent != null) {
            return Iterables.concat(options, this.parent.resolveTypeDependencies(type));
        }
        return options;
    }

    @Override
    public <T> Supplier<T> provideDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
        return () -> this.resolveDependency(type, selector);
    }

    @Override
    public <T> Supplier<T> provideDependency(Class<T> type) {
        return () -> this.resolveDependency(type);
    }

    @Override
    public <T> T satisfyDependency(T dependency) {
        Class<?> type = dependency.getClass();
        do {
            this.typeDependencies.put(type, dependency);
            Class<?>[] interfaces = type.getInterfaces();
            this.addInterfaces(interfaces, dependency);
        } while ((type = type.getSuperclass()) != null);
        return dependency;
    }

    public void satisfyDependencies(Object ... dependencies2) {
        for (Object dependency : dependencies2) {
            this.satisfyDependency(dependency);
        }
    }

    private <T> void addInterfaces(Class<?>[] interfaces, T dependency) {
        for (Class<?> type : interfaces) {
            this.typeDependencies.put(type, dependency);
            this.addInterfaces(type.getInterfaces(), dependency);
        }
    }
}

